/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.ILogWriter;
import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.driver.internal.LogElasticsearchWriterService;
import com.tandbergtv.workflow.log.LogConverterService;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;
import org.w3c.dom.Document;

public class LogEventListener
implements IColleague {
    private static final Logger LOGGER = Logger.getLogger(LogEventListener.class);
    private ISchedulerService<Void> scheduler;

    public LogEventListener(int threads) {
        this.scheduler = new Scheduler("log-event-listener", threads, threads);
        this.scheduler.start();
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(final WorkflowEvent event) {
        if (!(event instanceof WorkflowMessageLogEvent || event instanceof WorkflowProcessStatusLogEvent || event instanceof ProcessLogEvent)) {
            return;
        }
        this.scheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                String processId = "";
                Class processLogClass = null;
                ProcessLog log = null;
                ILogWriter writerService = (ILogWriter)ServiceRegistry.getDefault().lookup(LogElasticsearchWriterService.class);
                LogConverterService converterService = (LogConverterService)ServiceRegistry.getDefault().lookup(LogConverterService.class);
                if (event instanceof WorkflowMessageLogEvent) {
                    log = this.convertEventToMessageLog((WorkflowMessageLogEvent)event);
                    processId = Long.toString(((WorkflowMessageLogEvent)event).getToken().getProcessInstance().getId());
                    processLogClass = MessageLog.class;
                } else if (event instanceof WorkflowProcessStatusLogEvent) {
                    log = this.convertEventToProcessStatusLog((WorkflowProcessStatusLogEvent)event);
                    processId = Long.toString(((WorkflowProcessStatusLogEvent)event).getToken().getProcessInstance().getId());
                    processLogClass = ProcessStatusPerResourceLog.class;
                } else if (event instanceof ProcessLogEvent) {
                    log = ((ProcessLogEvent)event).getLog();
                    processId = Long.toString(((CustomToken)event.getSource()).getProcessInstance().getId());
                    processLogClass = NodeLog.class;
                }
                Map<String, Object> logMap = converterService.convert(processLogClass, log);
                logMap.put("processId", processId);
                writerService.save(logMap);
                return null;
            }

            private MessageLog convertEventToMessageLog(WorkflowMessageLogEvent event2) {
                String message = "";
                try {
                    Document document = Marshaller.newMarshaller().marshal(event2.getWfsMessage());
                    message = XMLDocumentUtility.convertToString(document);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"An exception was thrown while trying to read the WorkflowMessageLogEvent's message", (Throwable)e);
                }
                String messageUID = event2.getWfsMessage().getMessageUID().getUID();
                IMessageRegistry registry = ((IAdaptorService)ServiceRegistry.getDefault().lookup(IAdaptorService.class)).getMessageRegistry();
                IMessageUID registryMessageUID = registry != null ? registry.getMessageUID(messageUID) : null;
                WorkflowMessageLog workflowMessageLog = new WorkflowMessageLog();
                workflowMessageLog.setId(event2.getToken().getProcessInstance().getId());
                workflowMessageLog.setTimestamp(event2.getTimestamp());
                workflowMessageLog.setMessage(message);
                workflowMessageLog.setMessageName(registryMessageUID == null ? "" : registryMessageUID.getName());
                workflowMessageLog.setMessageUID(messageUID);
                workflowMessageLog.setMessageType(event2.getWfsMessage().getType().name());
                workflowMessageLog.setIncoming(event2.isIncoming());
                workflowMessageLog.setNode(LogEventListener.this.getResourceGroupAwareNode(event2.getNode()));
                workflowMessageLog.setResource(event2.getResource());
                workflowMessageLog.setToken(event2.getToken());
                return new MessageLog(workflowMessageLog);
            }

            private ProcessStatusPerResourceLog convertEventToProcessStatusLog(WorkflowProcessStatusLogEvent event2) {
                ProcessStatusPerResourceLog log = new ProcessStatusPerResourceLog();
                log.setNodeId(event2.getNode().getId());
                log.setResourceGroupId(event2.getResourceGroup().getId());
                log.setResourceId(event2.getResource().getId());
                log.setStartTime(event2.getStartTime());
                log.setEndTime(event2.getEndTime());
                log.setOperationalStatus(event2.getOperationalStatus());
                log.setAdminStatus(event2.getAdminStatus());
                log.setTokenId(event2.getToken().getId());
                return log;
            }
        });
    }

    private Node getResourceGroupAwareNode(Node node) {
        Node parent = node;
        while (parent.getSuperState() instanceof SuperState) {
            if (!((parent = parent.getSuperState()) instanceof NodeGroup)) continue;
            return parent;
        }
        return node;
    }
}

