/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.boot;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.internal.DistributedCache;
import com.tandbergtv.workflow.core.service.internal.DistributedQueueService;
import com.tandbergtv.workflow.core.service.internal.DistributedScheduler;
import com.tandbergtv.workflow.core.service.internal.RecoverableDistributedScheduler;
import com.tandbergtv.workflow.core.service.queue.IDistributedQueueService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.settings.ISettingsProvider;
import com.tandbergtv.workflow.core.settings.SettingsPluginLoader;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.EngineDriver;
import com.tandbergtv.workflow.driver.ILogWriter;
import com.tandbergtv.workflow.driver.NodeLogListener;
import com.tandbergtv.workflow.driver.boot.EngineDriverProperties;
import com.tandbergtv.workflow.driver.command.buffer.DelayedCommandService;
import com.tandbergtv.workflow.driver.command.buffer.IDelayedCommandService;
import com.tandbergtv.workflow.driver.internal.DefaultProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.internal.HibernatePersistenceService;
import com.tandbergtv.workflow.driver.internal.LogElasticsearchWriterService;
import com.tandbergtv.workflow.driver.internal.MessageQueueService;
import com.tandbergtv.workflow.driver.internal.ProcessManager;
import com.tandbergtv.workflow.driver.internal.TaskCompletionService;
import com.tandbergtv.workflow.driver.internal.TransportClientFactory;
import com.tandbergtv.workflow.driver.internal.callable.ReadClusterProperties;
import com.tandbergtv.workflow.driver.internal.monitor.ExecutionTimeMonitor;
import com.tandbergtv.workflow.driver.internal.monitor.GenericAlarmNotificationProvider;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.search.TokenSearchService;
import com.tandbergtv.workflow.driver.search.elasticsearch.WFSElasticSearchService;
import com.tandbergtv.workflow.driver.service.IMessageQueueService;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.service.ITaskCompletionService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.driver.template.TemplateLoaderService;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import com.tandbergtv.workflow.driver.timer.TimerManager;
import com.tandbergtv.workflow.exe.email.IEmailService;
import com.tandbergtv.workflow.exe.email.SimpleEmailService;
import com.tandbergtv.workflow.log.LogConverterService;
import com.tandbergtv.workflow.log.LogSyncService;
import com.tandbergtv.workflow.log.WorkflowLogService;
import com.tandbergtv.workflow.monitor.Observers;
import com.tandbergtv.workflow.monitor.core.IRecorder;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationService;
import com.tandbergtv.workflow.monitor.event.IEventHandlerRegistry;
import com.tandbergtv.workflow.settings.ISettingUpdateListenter;
import com.tandbergtv.workflow.settings.NeptuneSettingsCache;
import com.tandbergtv.workflow.settings.NeptuneSettingsLoaderService;
import com.tandbergtv.workflow.settings.RemoteSettingsUpdateNotificationService;
import com.tandbergtv.workflow.util.ApplicationProperties;
import com.tandbergtv.workflow.web.util.LicenseProviderFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.elasticsearch.client.transport.TransportClient;
import org.hibernate.SessionFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class Activator {
    private static final String PROCESS_MONITOR_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=Cumulative";
    private static final String PROCESS_MONITOR_CURRENT_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=Current";
    private static final String PROCESS_MONITOR_TOKENS_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=CurrentBranched";
    private static final Logger LOGGER = Logger.getLogger(Activator.class);

    public void start() {
        this.initializeJbpmTypes();
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".driver");
        EngineDriver driver = EngineDriver.getInstance();
        DefaultMediator.getInstance().register((IColleague)driver);
        IEventHandlerRegistry handlers = this.getService(IEventHandlerRegistry.class);
        handlers.registerEventHandler(new NodeLogListener());
        handlers.registerEventHandler((IColleague)new ExecutionTimeMonitor());
        this.addService((Service)new DistributedCache("Delete Template Cache"));
        int size = Integer.parseInt(bundle.getString("driver.cache.size"));
        WorkflowProcessCache cache = new WorkflowProcessCache(bundle.getString("driver.cache.name"), size);
        this.addService((Service)cache);
        SessionFactory factory = HibernateUtil.getSessionFactory();
        this.addService((Service)new WFSElasticSearchService(factory));
        Properties properties = new Properties();
        properties.setProperty("template.max.count", Integer.toString(Integer.MAX_VALUE));
        this.addService((Service)new TemplateLoaderService(properties, factory));
        this.addService((Service)new TokenSearchService(factory));
        this.addService((Service)new HibernatePersistenceService(factory));
        this.addService((Service)new NeptuneSettingsCache());
        this.addService(new SimpleEmailService());
        this.addService(new NeptuneSettingsLoaderService());
        this.addService((Service)new RecoverableDistributedScheduler("distributed-scheduler", 4));
        this.addService((Service)new DistributedScheduler("one-shot-distributed-scheduler", 8));
        this.addService((Service)new TaskCompletionService());
        this.addService((Service)new TimerManager());
        this.addService(new DelayedCommandService());
        this.addService((Service)new DistributedQueueService("distributed-queue"));
        this.addService((Service)new MessageQueueService());
        this.addService((Service)new DefaultProgressTrackingStrategy());
        this.addNeptuneSettingUpdateNotificationService();
        int core = Integer.parseInt(bundle.getString("messages.pool.size"));
        int max = Integer.parseInt(bundle.getString("messages.pool.max"));
        Properties props = this.getProperties();
        try {
            max = core = Integer.parseInt(props.getProperty("pool.size"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.addService((Service)new Scheduler("message-thread", core, max));
        int limit = Integer.MAX_VALUE;
        try {
            limit = Integer.parseInt(LicenseProviderFactory.getLicenseProvider().getProperty("ingest.thruput"));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Failed to read license", (Throwable)e);
        }
        props.setProperty("create.limit", String.valueOf(limit));
        ProcessManager service = new ProcessManager(props);
        this.registerMBeans((IProcessManagerService)service);
        ServiceRegistry.getDefault().register(service.getServiceName(), (Service)service);
        service.start();
        this.getService(IAlarmNotificationService.class).addProvider((IAlarmNotificationProvider)new GenericAlarmNotificationProvider());
        this.setupHistoryLogging(props, factory);
        if (Cluster.isMaster()) {
            service.recover();
        }
    }

    private void addNeptuneSettingUpdateNotificationService() {
        RemoteSettingsUpdateNotificationService service = new RemoteSettingsUpdateNotificationService();
        service.addUpdateListener(new ISettingUpdateListenter(){

            public String getPath() {
                return "WF_LICENSE_SETTING";
            }

            public void changed(Map<String, String> setting) {
                Integer limit = Configuration.toInteger((String)setting.get("ingest.thruput"), (int)Integer.MAX_VALUE);
                IProcessManagerService service = (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
                service.setLicenseCreatedLimit(limit.intValue());
            }
        });
        this.addService(service);
    }

    public void stop() {
        this.removeService(LogConverterService.class);
        this.removeService(ILogWriter.class);
        this.removeService(LogSyncService.class);
        this.removeService(WorkflowLogService.class);
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".driver");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_MBEAN_NAME));
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_CURRENT_MBEAN_NAME));
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_TOKENS_MBEAN_NAME));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"ProcessMonitor MBean unregistration failed");
        }
        EngineDriver driver = EngineDriver.getInstance();
        DefaultMediator.getInstance().unregister((IColleague)driver);
        this.removeService(IProcessManagerService.class);
        this.removeService(IProgressTrackingStrategy.class);
        this.removeService(ITimerService.class);
        this.removeService(IMessageQueueService.class);
        this.removeService(IDistributedQueueService.class);
        this.removeService(IDelayedCommandService.class);
        this.removeService("message-thread");
        this.removeService(ITaskCompletionService.class);
        this.removeService("one-shot-distributed-scheduler");
        this.removeService("distributed-scheduler");
        this.removeService(RemoteSettingsUpdateNotificationService.class);
        this.removeService(NeptuneSettingsLoaderService.class);
        this.removeService(IEmailService.class);
        this.removeService("WFS:NeptuneSettingsCache");
        this.removeService(ITemplateLoaderService.class);
        this.removeService(IPersistenceService.class);
        this.removeService(ITokenSearchService.class);
        this.removeService(IProcessSearchService.class);
        this.removeService(bundle.getString("driver.cache.name"));
        this.removeService("Delete Template Cache");
        LOGGER.info((Object)"Process execution runtime destroyed");
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void removeService(String name) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup(name);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void setupHistoryLogging(final Properties props, SessionFactory factory) {
        final String dir = this.getHistoryDirectory();
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        Long archivingPeriod = this.getProperty(props, "history.archiving.period", TimeUnit.HOURS.toSeconds(6L));
        Integer retentionWindow = (int)this.getProperty(props, "history.retention.period.days", 30L);
        Properties clusterProperties = this.getClusterProperties();
        final TransportClient client = TransportClientFactory.createTransportClient((Properties)clusterProperties);
        this.addService(new WorkflowLogService(factory, dir, archivingPeriod, retentionWindow, 1, client));
        this.setupHistorySync(props, client, dir);
        Hazelcast.getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent e) {
            }

            public void memberRemoved(MembershipEvent e) {
                Activator.this.setupHistorySync(props, client, dir);
            }
        });
        this.addService((Service)new LogElasticsearchWriterService(clusterProperties));
        this.addService(new LogConverterService());
    }

    private void setupHistorySync(Properties neptuneProps, TransportClient client, String dir) {
        if (!Cluster.isMaster()) {
            return;
        }
        if (this.getService(LogSyncService.class) != null) {
            return;
        }
        ((WorkflowLogService)ServiceRegistry.getDefault().lookup(WorkflowLogService.class)).startGCOnMaster();
        Long syncPeriod = this.getProperty(neptuneProps, "history.sync.period", TimeUnit.HOURS.toSeconds(1L));
        this.addService(new LogSyncService(HibernateUtil.getSessionFactory(), syncPeriod, client));
    }

    private void registerMBeans(IProcessManagerService service) {
        IStatistics statistics = service.getStatistics();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(statistics.getCumulativeStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_MBEAN_NAME));
            mbean = new StandardMBean(statistics.getProcessStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_CURRENT_MBEAN_NAME));
            mbean = new StandardMBean(statistics.getTokenStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_TOKENS_MBEAN_NAME));
            IRecorder recorder = (IRecorder)ServiceRegistry.getDefault().lookup("log-recorder");
            recorder.addObserver(Observers.localJMXObserver((String)"com.tandbergtv.watchpoint:type=ExecutionTime,*", (String)"EWMA"));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Registration of MBean failed, monitoring will not be available", (Throwable)e);
        }
    }

    private void initializeJbpmTypes() {
        String resource = JbpmConfiguration.Configs.getString((String)"resource.varmapping");
        InputStream is = ClassLoaderUtil.getStream((String)resource);
        Element rootElement = XmlUtil.parseXmlInputStream((InputStream)is).getDocumentElement();
        ObjectInfo oi = new ObjectFactoryParser().parse(XmlUtil.element((Element)rootElement, (String)"list"));
        ObjectFactoryImpl of = (ObjectFactoryImpl)JbpmConfiguration.Configs.getObjectFactory();
        of.addObjectInfo(oi);
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String getHistoryDirectory() {
        try {
            return ApplicationProperties.getInstance().getProperty("install.dir") + "/history/process/";
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long getProperty(Properties props, String name, long value) {
        return Long.valueOf(props.getProperty(name, String.valueOf(value)));
    }

    private Properties getProperties() {
        EngineDriverProperties props = new EngineDriverProperties();
        String alarmsIntervalProperty = null;
        ISettingsProvider provider = this.getSettingProvider();
        if (provider != null) {
            alarmsIntervalProperty = provider.getProperties("com.ericsson.cms.neptune.uialerts.timeinterval").get("time_interval");
        }
        if (alarmsIntervalProperty == null) {
            alarmsIntervalProperty = "2";
        }
        props.setProperty("time_interval", alarmsIntervalProperty);
        if (Cluster.isMaster()) {
            return props;
        }
        ISchedulerService scheduler = (ISchedulerService)ServiceRegistry.getDefault().lookup("one-shot-distributed-scheduler");
        Future future = scheduler.schedule((Callable)new ReadClusterProperties());
        Properties properties = new Properties();
        try {
            properties = (Properties)future.get(30L, TimeUnit.SECONDS);
            for (Object name : properties.keySet()) {
                props.put(name, properties.get(name));
                LOGGER.debug((Object)(name + "=" + properties.get(name)));
            }
            props.store();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to get properties from master", (Throwable)e);
        }
        return props;
    }

    private ISettingsProvider getSettingProvider() {
        SettingsPluginLoader settingsPluginLoader = new SettingsPluginLoader();
        ISettingsProvider provider = settingsPluginLoader.createSettingsProvider();
        return provider;
    }

    private Properties getClusterProperties() {
        String clusterPropertiesFile = System.getProperty("com.tandbergtv.cms.product.dir", "/opt/tandbergtv/cms") + "/conf/workflow/WFSElasticSearch.properties";
        Properties props = new Properties();
        try {
            FileReader reader = new FileReader(clusterPropertiesFile);
            props.load(reader);
            reader.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn((Object)("Could not find properties file: " + clusterPropertiesFile), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"There was an error while reading properties", (Throwable)e);
        }
        return props;
    }
}

