/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.registration;

import com.tandbergtv.workflow.adaptor.AdaptorException;
import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.adaptor.conf.AdaptorConfigurationImpl;
import com.tandbergtv.workflow.adaptor.conf.IAdaptorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.IMessageProcessorConfiguration;
import com.tandbergtv.workflow.adaptor.conf.PluginConfigurationLoader;
import com.tandbergtv.workflow.adaptor.internal.DefaultAdaptor;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.adaptor.registration.DynamicProxyAdaptor;
import com.tandbergtv.workflow.adaptor.registration.IAdaptorRegistration;
import com.tandbergtv.workflow.adaptor.registration.IDynamicProxyAdaptor;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.pluginmanager.entities.AdaptorDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.MessageDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdaptorRegistration
implements IAdaptorRegistration {
    private static final Logger LOGGER = Logger.getLogger(AdaptorRegistration.class);
    private IAdaptorRegistry adaptorRegistry = null;
    private IMessageRegistry messageRegistry = null;

    public AdaptorRegistration() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        this.adaptorRegistry = ((IAdaptorService)registry.lookup(IAdaptorService.class)).getRegistry();
        this.messageRegistry = ((IAdaptorService)registry.lookup(IAdaptorService.class)).getMessageRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAdaptor(ResourceTypeDescriptor resourceTypeDescriptor) throws AdaptorException {
        String systemId = resourceTypeDescriptor.getSystemId();
        IAdaptor currentAdaptor = this.adaptorRegistry.getDeviceAdaptor(systemId);
        IAdaptor adaptor = this.getAdaptor(resourceTypeDescriptor);
        Set<IMessageUID> messages = this.getMessages(resourceTypeDescriptor);
        if (currentAdaptor instanceof IDynamicProxyAdaptor) {
            IDynamicProxyAdaptor proxy = (IDynamicProxyAdaptor)IDynamicProxyAdaptor.class.cast(currentAdaptor);
            proxy.getAdaptorLock().writeLock().lock();
            try {
                this.messageRegistry.registerMessages(systemId, messages);
                if (adaptor == null) {
                    this.adaptorRegistry.unregisterDeviceAdaptor(systemId);
                }
                proxy.update(adaptor);
            }
            finally {
                proxy.getAdaptorLock().writeLock().unlock();
            }
        } else {
            DynamicProxyAdaptor proxy = new DynamicProxyAdaptor(adaptor);
            proxy.getAdaptorLock().writeLock().lock();
            try {
                this.messageRegistry.registerMessages(systemId, messages);
                if (adaptor == null) {
                    this.adaptorRegistry.unregisterDeviceAdaptor(systemId);
                } else {
                    this.adaptorRegistry.registerDeviceAdaptor(systemId, (IAdaptor)proxy);
                }
            }
            finally {
                proxy.getAdaptorLock().writeLock().unlock();
            }
        }
    }

    @Override
    public void unregisterAdaptor(ResourceTypeDescriptor resourceTypeDescriptor) {
        this.unregisterAdaptor(resourceTypeDescriptor.getSystemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAdaptor(String deviceSystemId) {
        IAdaptor adaptor = this.adaptorRegistry.getDeviceAdaptor(deviceSystemId);
        IDynamicProxyAdaptor proxy = null;
        if (adaptor instanceof IDynamicProxyAdaptor) {
            proxy = (IDynamicProxyAdaptor)adaptor;
        }
        if (proxy != null) {
            proxy.getAdaptorLock().writeLock().lock();
        }
        try {
            this.adaptorRegistry.unregisterDeviceAdaptor(deviceSystemId);
            this.messageRegistry.unregisterMessages(deviceSystemId);
        }
        finally {
            if (proxy != null) {
                proxy.getAdaptorLock().writeLock().unlock();
            }
        }
    }

    private Set<IMessageUID> getMessages(ResourceTypeDescriptor descriptor) {
        HashSet<IMessageUID> messages = new HashSet<IMessageUID>();
        for (MessageDescriptor message : descriptor.getMessages().values()) {
            messages.add((IMessageUID)new MessageUIDImpl(message.getUID(), message.getName()));
        }
        return messages;
    }

    private IAdaptor getAdaptor(ResourceTypeDescriptor resourceTypeDescriptor) throws AdaptorException {
        if (resourceTypeDescriptor.getAdaptor() == null) {
            return null;
        }
        AdaptorDescriptor descriptor = resourceTypeDescriptor.getAdaptor();
        IAdaptor adaptor = null;
        adaptor = descriptor.isDefault() ? this.createDefaultAdaptor(resourceTypeDescriptor) : this.createCustomAdaptor(resourceTypeDescriptor);
        return adaptor;
    }

    private IAdaptor createDefaultAdaptor(ResourceTypeDescriptor descriptor) throws AdaptorException {
        DefaultAdaptor adaptor = new DefaultAdaptor(descriptor.getSystemId());
        adaptor.init((IAdaptorConfiguration)new AdaptorConfigurationImpl(descriptor.getAdaptor().getProperties()));
        String identifierClassName = descriptor.getAdaptor().getMessageIdentifierClass();
        if (identifierClassName != null && identifierClassName.length() > 0) {
            LOGGER.debug((Object)("Creating default adaptor message identifier: " + identifierClassName + " for resource type plugin[" + descriptor + "]"));
            IMessageIdentifier messageIdentifier = (IMessageIdentifier)this.createInstance(descriptor, "message identifier", identifierClassName);
            adaptor.addMessageIDClass(messageIdentifier);
        }
        Map messages = descriptor.getMessages();
        ClassLoader classLoader = descriptor.getClassLoader();
        for (String key : messages.keySet()) {
            MessageDescriptor messageDesciptor = (MessageDescriptor)messages.get(key);
            MessageUIDImpl uid = new MessageUIDImpl(messageDesciptor.getUID());
            PluginConfigurationLoader loader = new PluginConfigurationLoader(descriptor.getRetryInterval(), descriptor.getRetryCount());
            IMessageProcessorConfiguration conf = loader.getConfiguration(classLoader, (IMessageUID)uid);
            LOGGER.debug((Object)("Adding configuration for UID " + uid));
            adaptor.addConfiguration((IMessageUID)uid, conf);
        }
        return adaptor;
    }

    private IAdaptor createCustomAdaptor(ResourceTypeDescriptor descriptor) throws AdaptorException {
        String className = descriptor.getAdaptor().getAdaptorClass();
        LOGGER.debug((Object)("Creating custom adaptor: " + className + " for resource type plugin[" + descriptor + "]"));
        IAdaptor adaptor = (IAdaptor)this.createInstance(descriptor, "adaptor", className);
        adaptor.init((IAdaptorConfiguration)new AdaptorConfigurationImpl(descriptor.getAdaptor().getProperties()));
        return adaptor;
    }

    private <T> T createInstance(ResourceTypeDescriptor descriptor, String classType, String className) throws AdaptorException {
        try {
            ClassLoader classLoader = descriptor.getClassLoader();
            Class<?> clazz = classLoader.loadClass(className);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AdaptorException("Failed to find " + classType + " class " + className + " for resource type plugin[" + descriptor + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new AdaptorException("Error instantiating " + classType + " class " + className + " for resource type plugin[" + descriptor + "]", (Throwable)e);
        }
    }
}

