/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.ISet;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSVariableInstance;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchService;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.elasticsearch.IWFSElasticSearchPersistanceHelper;
import com.tandbergtv.workflow.driver.search.elasticsearch.WFSElasticSearchFilterBuilder;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsPersistanceSynchronizer;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsProcessHelper;
import com.tandbergtv.workflow.driver.search.event.ProcessPersistEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.hibernate.SessionFactory;

public class WFSElasticSearchService
extends SearchService
implements IWFSElasticSearchPersistanceHelper,
IColleague {
    private static final Logger LOGGER = Logger.getLogger(WFSElasticSearchService.class);
    private static final String CONFIG_FILE = System.getProperty("com.tandbergtv.cms.product.dir", "/opt/tandbergtv/cms") + "/conf/workflow/WFSElasticSearch.properties";
    private static final boolean USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT = System.getProperty("workflow.elasticsearch.sync.util", "").isEmpty();
    private TransportClient client;
    private WfsEsProcessHelper esProcessHelper = WfsEsProcessHelper.getInstance();
    private static final int DEFAULT_PORT = 9300;
    private long writeTimeoutMs;
    private long readTimeoutMs;
    private long retryTimeoutMs;
    private static final String SAVE_FAILED_MAP = "ES_SAVE_MAP";
    private static final String DELETE_FAILED_MAP = "ES_DELETE_MAP";
    private ExecutorService executor = Executors.newFixedThreadPool(2);
    private IWFSElasticSearchPersistanceHelper persistanceHelper;
    private Thread asyncESSynchronizer;
    private boolean running = true;
    private ISchedulerService<Void> scheduler;
    private BulkProcessor processor;

    public WFSElasticSearchService(SessionFactory factory) {
        super(factory);
    }

    @Override
    public String getServiceName() {
        return super.getServiceName();
    }

    @Override
    public int count(ProcessStatus status) {
        return this.expressCount(this.getSearchCriteriaByProcessStatus(status));
    }

    @Override
    public int count(List<ProcessStatus> list) {
        return this.expressCount(this.getSearchCriteriaByProcessStatusList(list));
    }

    @Override
    public void start() {
        LOGGER.debug((Object)"Starting WFSElasticSearch service...");
        try {
            Properties props = this.readConfiguration();
            this.initTimeouts(props);
            String clusterName = props.getProperty("cluster.name");
            LOGGER.debug((Object)("Cluster name: " + clusterName));
            Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).build();
            this.client = new TransportClient(settings);
            String hosts = props.getProperty("hosts");
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String hostEntry = tkz.nextToken().trim();
                if (hostEntry.length() <= 0) continue;
                int port = 9300;
                String host = hostEntry;
                int idx = hostEntry.indexOf(58);
                if (idx > 0) {
                    try {
                        port = Integer.parseInt(hostEntry.substring(idx + 1));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    host = hostEntry.substring(0, idx);
                }
                this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(host, port));
                LOGGER.debug((Object)("Added host: " + host + ":" + port));
            }
            this.processor = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)this.listener()).setFlushInterval(TimeValue.timeValueSeconds((long)10L)).build();
            this.scheduler = new Scheduler("process-elasticsearch-save", 1, 1);
            this.scheduler.start();
            DefaultMediator.getInstance().register((IColleague)this);
            this.persistanceHelper = this;
            this.running = true;
            this.asyncESSynchronizer = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (WFSElasticSearchService.this.running) {
                        if (USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT && Cluster.isMaster()) {
                            WfsEsPersistanceSynchronizer synchronizer;
                            Long[] wip;
                            ISet failedSet = Hazelcast.getSet((String)WFSElasticSearchService.DELETE_FAILED_MAP);
                            if (failedSet != null) {
                                for (Long procId : wip = failedSet.toArray(new Long[failedSet.size()])) {
                                    failedSet.remove(procId);
                                    synchronizer = new WfsEsPersistanceSynchronizer(procId, WFSElasticSearchService.this.persistanceHelper, true);
                                    WFSElasticSearchService.this.executor.execute(synchronizer);
                                }
                            }
                            if ((failedSet = Hazelcast.getSet((String)WFSElasticSearchService.SAVE_FAILED_MAP)) != null) {
                                for (Long procId : wip = failedSet.toArray(new Long[failedSet.size()])) {
                                    failedSet.remove(procId);
                                    synchronizer = new WfsEsPersistanceSynchronizer(procId, WFSElasticSearchService.this.persistanceHelper, false);
                                    WFSElasticSearchService.this.executor.execute(synchronizer);
                                }
                            }
                        }
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    WFSElasticSearchService.this.executor.shutdown();
                }
            });
            this.asyncESSynchronizer.start();
            LOGGER.debug((Object)"Started WFSElasticSearch service");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not connect to ElasticSearch.", (Throwable)e);
        }
    }

    private Properties readConfiguration() throws Exception {
        FileReader reader = new FileReader(CONFIG_FILE);
        Properties props = new Properties();
        props.load(reader);
        reader.close();
        return props;
    }

    private void initTimeouts(Properties props) {
        this.writeTimeoutMs = Long.valueOf(props.getProperty("timeout.write", "60")) * 1000L;
        this.readTimeoutMs = Long.valueOf(props.getProperty("timeout.read", "60")) * 1000L;
        this.retryTimeoutMs = Long.valueOf(props.getProperty("timeout.retry", "200")) * 1000L;
    }

    @Override
    public void stop() {
        LOGGER.debug((Object)"Stopping ElasticSearch service...");
        this.scheduler.stop();
        if (this.asyncESSynchronizer != null) {
            this.asyncESSynchronizer.interrupt();
        }
        this.running = false;
        DefaultMediator.getInstance().unregister((IColleague)this);
        try {
            this.client.close();
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
        LOGGER.debug((Object)"Stopped ElasticSearch service.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void softDelete(WorkflowProcess process) throws Exception {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            return;
        }
        String procId = String.valueOf(process.getId());
        LOGGER.debug((Object)("Saving process[" + procId + "]"));
        try (XContentBuilder source = this.createProcess(process);){
            this.trySaving(procId, source, this.client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WorkflowProcess process) throws Exception {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            return;
        }
        String id = String.valueOf(process.getId());
        LOGGER.debug((Object)("Saving process[" + id + "]"));
        try (XContentBuilder source = this.createProcess(process);){
            this.processor.add((IndexRequest)this.client.prepareIndex("wfs", "processinstance", id).setSource(source).request());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(WFSearchResult result) throws Exception {
        if (result == null || result.getProcessId() < 1L || result.getToken().getTokenId() < 1L) {
            return;
        }
        String procId = String.valueOf(result.getProcessId());
        LOGGER.debug((Object)("Saving process[" + procId + "]"));
        try (XContentBuilder source = this.createBuilder(result);){
            this.savingNoWait(procId, source, this.client);
        }
    }

    public XContentBuilder createProcess(WorkflowProcess process) throws IOException {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            throw new IllegalArgumentException("Process appears to be invalid");
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.prettyPrint();
        builder.startObject();
        this.esProcessHelper.addSearchFields(builder, process);
        builder.endObject();
        return builder;
    }

    public XContentBuilder createBuilder(WFSearchResult wfsResult) throws IOException {
        if (wfsResult == null || wfsResult.getProcessId() < 1L || wfsResult.getToken().getTokenId() < 1L) {
            throw new IllegalArgumentException("WFSearchResult appears to be invalid");
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.prettyPrint();
        builder.startObject();
        this.esProcessHelper.addSearchFields(builder, wfsResult);
        builder.endObject();
        return builder;
    }

    public boolean trySaving(String id, XContentBuilder source, TransportClient client) {
        if (client == null) {
            LOGGER.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = client.prepareIndex("wfs", "processinstance", id);
            bld.setSource(source);
            bld.execute().actionGet(this.writeTimeoutMs);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    public boolean savingNoWait(String id, XContentBuilder source, TransportClient client) {
        if (client == null) {
            LOGGER.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = client.prepareIndex("wfs", "processinstance", id);
            bld.setSource(source);
            bld.execute();
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    public boolean tryDeleting(String id, TransportClient client) {
        if (client == null) {
            LOGGER.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            DeleteRequestBuilder bld = client.prepareDelete("wfs", "processinstance", id);
            bld.execute().actionGet(this.writeTimeoutMs);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not delete process " + id), (Throwable)e);
            return false;
        }
    }

    private void saveFailedProcessId(long id, boolean deleting) {
        if (!USE_HAZELCAST_TO_HANDLE_FAILED_ATTEMPT) {
            LOGGER.fatal((Object)("Failed attempt of saving process Id " + id + " to reindex later for " + (deleting ? "delete" : "save") + " operation."));
            throw new RuntimeException("Failed attempt of saving process Id " + id + " to reindex later for " + (deleting ? "delete" : "save") + " operation.");
        }
        LOGGER.info((Object)("Saving process Id " + id + " to reindex later for " + (deleting ? "delete" : "save") + " operation."));
        ISet failedSet = deleting ? Hazelcast.getSet((String)DELETE_FAILED_MAP) : Hazelcast.getSet((String)SAVE_FAILED_MAP);
        failedSet.add(id);
    }

    @Override
    public void delete(long id) throws Exception {
        String procId = String.valueOf(id);
        LOGGER.debug((Object)("Deleting process[" + procId + "]"));
        long t1 = System.currentTimeMillis();
        while (!this.tryDeleting(procId, this.client)) {
            long t2;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((t2 = System.currentTimeMillis()) - t1 <= this.retryTimeoutMs) continue;
            this.saveFailedProcessId(id, true);
            return;
        }
    }

    @Override
    public void softDelete(long id) throws Exception {
        String procId = String.valueOf(id);
        XContentBuilder contentBuilder = JsonXContent.contentBuilder().startObject();
        contentBuilder.field("isActive", false);
        contentBuilder.endObject();
        UpdateRequest updateRequest = new UpdateRequest("wfs", "processinstance", procId);
        updateRequest.doc(contentBuilder);
        this.client.update(updateRequest).get(this.writeTimeoutMs, TimeUnit.MILLISECONDS);
    }

    private List<WFSearchResult> expressSearchGetChildren(List<SearchParameterBase> whereList, List<SearchParameterBase> sortList) {
        long start = System.currentTimeMillis();
        String parentIdPredicate = null;
        boolean hidesubprocess = false;
        for (SearchParameterBase param : whereList) {
            String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(param.getFieldName());
            if ("id".equalsIgnoreCase(esPropertyName)) {
                parentIdPredicate = param.getPredicate();
                parentIdPredicate = parentIdPredicate.substring(parentIdPredicate.indexOf("= ") + 2);
                continue;
            }
            if (!"hidesubprocess".equalsIgnoreCase(param.getFieldName())) continue;
            hidesubprocess = true;
        }
        ArrayList<WFSearchResult> processes = new ArrayList<WFSearchResult>();
        processes.add(this.convertProcess(parentIdPredicate, hidesubprocess));
        LOGGER.debug((Object)("Total getChildren: " + (System.currentTimeMillis() - start) + " ms."));
        return processes;
    }

    private WFSearchResult convertProcess(String processIdAsString, boolean hidesubprocess) {
        WorkflowProcess proc = ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).get(Long.valueOf(Long.parseLong(processIdAsString)));
        WFSearchResult result = new WFSearchResult();
        result.setProcessId(proc.getId());
        result.setProcessDefinitionName(proc.getProcessDefinition().getFullName());
        result.setRootTokenId(proc.getRootToken().getId());
        WFToken token = new WFToken();
        result.setToken(token);
        this.convertToken(proc.getRootToken(), token, result, hidesubprocess);
        if (proc.getSuperProcessToken() == null) {
            Set vars = proc.getVariables();
            Iterator varItr = vars.iterator();
            int varsFound = 0;
            while (varItr.hasNext()) {
                WFSVariableInstance var = (WFSVariableInstance)varItr.next();
                if (!"titleId".equalsIgnoreCase(var.getName()) && !"title_id".equalsIgnoreCase(var.getName()) && !"titlebrief".equalsIgnoreCase(var.getName()) && !"title_brief".equalsIgnoreCase(var.getName()) && !"licensestart".equalsIgnoreCase(var.getName()) && !"license_start".equalsIgnoreCase(var.getName()) && !"licenseend".equalsIgnoreCase(var.getName()) && !"license_end".equalsIgnoreCase(var.getName()) && !"ingestTemplate".equalsIgnoreCase(var.getName()) && !"providerid".equalsIgnoreCase(var.getName()) && !"provider_id".equalsIgnoreCase(var.getName())) continue;
                this.addVar(result.getVariables(), var);
                if (++varsFound < 6) continue;
                break;
            }
        }
        return result;
    }

    private void addVar(Map<String, WFVariable> wfVariables, WFSVariableInstance var) {
        WFVariable newVar = new WFVariable();
        newVar.setName(var.getName());
        newVar.addValue(var.getStringVal());
        wfVariables.put(newVar.getName(), newVar);
    }

    private void convertToken(CustomToken rootToken, WFToken token, WFSearchResult result, boolean hidesubprocess) {
        token.setAdministrativeStatus(rootToken.getRequestedStatus().ordinal());
        token.setEndTime(rootToken.getEnd());
        if (rootToken.getErrorDetails() != null) {
            token.setErrorComment(rootToken.getErrorDetails().getMessage());
            token.setErrorTime(rootToken.getErrorDetails().getTime());
        }
        token.setNodeName(rootToken.getCurrentNode().getName());
        token.setOperationalStatus(rootToken.getStatus().ordinal());
        token.setProcessId(rootToken.getProcessInstance().getId());
        token.setStartTime(rootToken.getStart());
        token.setTokenId(rootToken.getId());
        if (!hidesubprocess) {
            SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
            this.esProcessHelper.addResultProperties(bld);
            AndFilterBuilder filterBuilder = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
            filterBuilder.add((FilterBuilder)FilterBuilders.termFilter((String)"superProcessTokenId", (long)rootToken.getId()));
            filterBuilder.add((FilterBuilder)FilterBuilders.termFilter((String)"isActive", (Object)true));
            bld.setPostFilter((FilterBuilder)filterBuilder);
            SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.readTimeoutMs);
            for (SearchHit hit : resp.getHits().hits()) {
                result.addChild(this.convertProcess("" + this.esProcessHelper.getLongField(hit, "id"), hidesubprocess));
            }
        }
        for (CustomToken child : rootToken.getChildTokens()) {
            WFToken chld = new WFToken();
            this.convertToken(child, chld, result, hidesubprocess);
            token.addChild(chld);
        }
    }

    @Override
    public List<WFSearchResult> expressSearch(SearchCriteria searchCriteria) {
        LOGGER.debug((Object)"Starting expressSearch --> ");
        List searchParameters = searchCriteria.getSearchList();
        ArrayList<SearchParameterBase> sortList = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> whereList = new ArrayList<SearchParameterBase>();
        boolean getChildren = false;
        for (SearchParameterBase param : searchParameters) {
            if (param instanceof SortParameter) {
                sortList.add(param);
                continue;
            }
            if (param.getPartialWhereClause() == null) continue;
            if ("getChildren".equalsIgnoreCase(param.getFieldName())) {
                getChildren = true;
                continue;
            }
            whereList.add(param);
        }
        if (getChildren) {
            return this.expressSearchGetChildren(whereList, sortList);
        }
        return this.expressSearchTopLevelProcesses(searchCriteria, whereList, sortList);
    }

    private List<WFSearchResult> expressSearchTopLevelProcesses(SearchCriteria searchCriteria, List<SearchParameterBase> whereList, List<SearchParameterBase> sortList) {
        long topLevelStart = System.currentTimeMillis();
        SearchRequestBuilder bld = this.client.prepareSearch(new String[]{"wfs"});
        this.esProcessHelper.addResultProperties(bld);
        for (SearchParameterBase sortParam : sortList) {
            FieldSortBuilder sort = SortBuilders.fieldSort((String)WfsEsParameters.mapUIColumnToESProperty(sortParam.getFieldName()));
            sort.order(SortingOrder.DESCENDING.equals((Object)sortParam.getSortingOrder()) ? SortOrder.DESC : SortOrder.ASC);
            sort.ignoreUnmapped(true);
            bld.addSort((SortBuilder)sort);
        }
        bld.setFrom(searchCriteria.getStartingRecordNumber());
        if (searchCriteria.getRecordsCount() > 0) {
            bld.setSize(searchCriteria.getRecordsCount());
        }
        LinkedList<Object> filterBuilders = new LinkedList<Object>();
        if (this.addActiveFilter(whereList)) {
            filterBuilders.add(FilterBuilders.termFilter((String)"isActive", (Object)true));
        }
        for (SearchParameterBase param : whereList) {
            FilterBuilder filterBuilder = WFSElasticSearchFilterBuilder.getFilterBuilder(param);
            if (filterBuilder == null) continue;
            filterBuilders.add(filterBuilder);
        }
        AndFilterBuilder filterBuilder = FilterBuilders.andFilter((FilterBuilder[])filterBuilders.toArray(new FilterBuilder[filterBuilders.size()]));
        bld.setPostFilter((FilterBuilder)filterBuilder);
        long startTime = System.currentTimeMillis();
        SearchResponse resp = (SearchResponse)bld.execute().actionGet(this.readTimeoutMs);
        LOGGER.debug((Object)("actionGet: " + (System.currentTimeMillis() - startTime) + " ms."));
        ArrayList<WFSearchResult> processes = new ArrayList<WFSearchResult>();
        long totalHits = resp.getHits().totalHits();
        startTime = System.currentTimeMillis();
        for (SearchHit hit : resp.getHits().hits()) {
            processes.add(this.esProcessHelper.convert(hit, totalHits));
        }
        LOGGER.debug((Object)("Object conversions: " + (System.currentTimeMillis() - startTime) + " ms."));
        LOGGER.debug((Object)("Total top level expressSearch: " + (System.currentTimeMillis() - topLevelStart) + " ms."));
        return processes;
    }

    private boolean addActiveFilter(List<SearchParameterBase> parameters) {
        for (SearchParameterBase parameter : parameters) {
            if (!"all".equals(parameter.getFieldName())) continue;
            return false;
        }
        return true;
    }

    private BulkProcessor.Listener listener() {
        return new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable e) {
                LOGGER.warn((Object)":(", e);
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                LOGGER.debug((Object)("Bulk request took " + response.getTookInMillis() + "msec"));
                if (response.hasFailures()) {
                    LOGGER.warn((Object)response.buildFailureMessage());
                }
            }
        };
    }

    @Override
    public int expressCount(SearchCriteria criteria) {
        List<WFSearchResult> result = this.expressSearch(criteria);
        return result == null || result.size() == 0 ? 0 : (int)result.get(0).getSearchResultCount();
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        if (event instanceof ProcessPersistEvent) {
            this.scheduler.schedule((Callable)new ProcessSaveCallable((ProcessPersistEvent)event));
        }
    }

    private class ProcessSaveCallable
    implements Callable<Void> {
        private ProcessPersistEvent event;

        ProcessSaveCallable(ProcessPersistEvent evt) {
            this.event = evt;
        }

        @Override
        public Void call() throws Exception {
            WorkflowProcess process = this.event.getProcess();
            if (!ProcessFinder.isOwner(process) && !this.event.isDeleted()) {
                return null;
            }
            try {
                if (this.event.isDeleted()) {
                    if (this.event.getProcess().isActive()) {
                        WFSElasticSearchService.this.delete(process.getId());
                    } else {
                        WFSElasticSearchService.this.softDelete(process);
                    }
                } else {
                    WFSElasticSearchService.this.save(process);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)(process + ", failed to persist in ElasticSearch"), (Throwable)e);
            }
            return null;
        }
    }
}

