/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.process;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.internal.CompositeCache;
import com.tandbergtv.workflow.driver.process.ProcessSerializer;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCacheWrapper;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class WorkflowProcessCache
extends CompositeCache<WorkflowProcess> {
    private static final Logger LOGGER = Logger.getLogger(WorkflowProcessCache.class);
    public static final String CACHE_NAME = "Process Cache";

    public WorkflowProcessCache(String name, int size) {
        super(name, size);
    }

    public void add(Serializable key, WorkflowProcess entity) {
        this.cache.add(key, (Object)entity);
        this.addDistributedCache(key, entity);
    }

    public void cache(long key, WorkflowProcess entity) {
        this.add((Serializable)Long.valueOf(key), entity);
    }

    public void cache(long id, WorkflowProcess entity, boolean l2CacheOnly) {
        if (l2CacheOnly) {
            this.addDistributedCache(Long.valueOf(id), entity);
        } else {
            this.cache(id, entity);
        }
    }

    public void uncache(long key) {
        this.remove(Long.valueOf(key));
    }

    private void addDistributedCache(Serializable key, WorkflowProcess process) {
        WorkflowProcessCacheWrapper cachedEntity = new WorkflowProcessCacheWrapper(process, ProcessSerializer.encode(process));
        long start = System.currentTimeMillis();
        this.getMap().put(key, cachedEntity);
        LOGGER.debug((Object)("Time taken to DistributedCache().add() - time: " + (System.currentTimeMillis() - start)));
    }

    public WorkflowProcess get(Serializable key) {
        WorkflowProcess entity = (WorkflowProcess)this.cache.get(key);
        if (entity == null) {
            long start = System.currentTimeMillis();
            WorkflowProcessCacheWrapper wrapper = (WorkflowProcessCacheWrapper)((Object)this.getMap().get(key));
            if (wrapper != null) {
                entity = ProcessSerializer.decode(wrapper.getCache());
                LOGGER.debug((Object)("Time taken to DistributedCache().get() - time: " + (System.currentTimeMillis() - start)));
            }
        }
        return entity;
    }
}

