/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.queue.IDistributedQueueService;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.message.MessageRejectedEvent;
import com.tandbergtv.workflow.driver.service.IMessageQueueService;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Token;

public class MessageQueueService
implements IMessageQueueService,
IColleague {
    private static final String SERVICE_NAME = "Message Queue";
    private static final Logger LOGGER = Logger.getLogger(MessageQueueService.class);

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        mediator.register((IColleague)this);
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
    }

    public void stop() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        mediator.unregister((IColleague)this);
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
    }

    @Override
    public void addMessage(Token token, WorkflowMessage message) {
        IMessageUID uid = message.getMessageUID();
        BlockingQueue<WorkflowMessage> queue = this.getQueue(token);
        if (queue == null) {
            LOGGER.warn((Object)(token + ", message queue unavailable, rejecting " + uid));
            return;
        }
        if (queue.size() > 0) {
            LOGGER.warn((Object)(token + ", queue size is " + queue.size()));
        }
        LOGGER.debug((Object)(token + ", adding message " + uid));
        long start = System.currentTimeMillis();
        queue.add(message);
        LOGGER.debug((Object)("Time taken to distributedQueue().add() - time:" + (System.currentTimeMillis() - start) + " token:" + token.getId() + " uid:" + uid));
    }

    @Override
    public BlockingQueue<WorkflowMessage> getQueue(Token token) {
        IDistributedQueueService service = (IDistributedQueueService)ServiceRegistry.getDefault().lookup(IDistributedQueueService.class);
        BlockingQueue queue = service.getQueue("token-" + token.getId());
        return queue;
    }

    private void removeQueue(Token token) {
        IDistributedQueueService service = (IDistributedQueueService)ServiceRegistry.getDefault().lookup(IDistributedQueueService.class);
        service.removeQueue("token-" + token.getId());
        LOGGER.debug((Object)(token + ", removed message queue"));
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        MessageRejectedEvent e;
        boolean removed;
        if (event instanceof WorkflowProcessEvent) {
            WorkflowProcessEvent e2 = (WorkflowProcessEvent)event;
            Token token = e2.getToken();
            switch (e2.getType()) {
                case STARTED: 
                case RESUMED: 
                case JOINED: {
                    if (!this.needsQueue(token)) break;
                    this.getQueue(token);
                    break;
                }
                case BRANCHED: 
                case PAUSED: 
                case CRASHED: 
                case FAILED: 
                case CANCELLED: 
                case STOPPED: {
                    if (!this.needsQueue(token)) break;
                    this.removeQueue(token);
                    break;
                }
            }
        } else if (event instanceof MessageRejectedEvent && (removed = this.getQueue((e = (MessageRejectedEvent)event).getToken()).remove(e.getMessage()))) {
            LOGGER.warn((Object)(e.getToken() + ", removed message [" + e.getMessage().getMessageUID() + "] from queue"));
        }
    }

    private boolean needsQueue(Token token) {
        ProcessDefinition template = token.getProcessInstance().getProcessDefinition();
        return ((WorkflowTemplate)template).hasAsyncMessages();
    }
}

