/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.StaleStateException;

public class RecoverToken
extends TokenCallable {
    private static final long serialVersionUID = 1007232026076120855L;

    public RecoverToken(CustomToken token) {
        super(token);
        if (!token.isRoot()) {
            throw new InvalidProcessStateException(token + " is not root");
        }
    }

    @Override
    public Object getKey() {
        return this.getPid();
    }

    @Override
    protected Callable<CustomToken> innerCallable(final CustomToken token) {
        return new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    WorkflowProcess process = token.getProcessInstance();
                    if (process.hasEnded()) {
                        Logger.getLogger(RecoverToken.class).warn((Object)(token + " has ended"));
                        RecoverToken.this.getCache().remove((Serializable)Long.valueOf(process.getId()));
                        return token;
                    }
                    ProcessFinder.updateOwner(process);
                    if (token.getStatus() == ProcessStatus.BRANCHED || token.getStatus() == ProcessStatus.ERROR || token.getSubProcessInstance() != null) {
                        RecoverToken.this.getCache().add((Serializable)Long.valueOf(process.getId()), (Object)process);
                    }
                    token.recover(RecoverToken.this.resumeOnRecovery());
                }
                catch (StaleStateException e) {
                    RecoverToken.this.handleStaleStateException(token);
                }
                catch (StackOverflowError e) {
                    RecoverToken.this.handleStackOverflowError(token, e);
                }
                catch (Throwable t) {
                    Logger.getLogger(RecoverToken.class).error((Object)token, t);
                }
                return token;
            }
        };
    }

    private void handleStaleStateException(CustomToken token) {
        try {
            token.getProcessInstance().resetId();
            token.recover(this.resumeOnRecovery());
        }
        catch (Throwable t) {
            Logger.getLogger(RecoverToken.class).error((Object)token, t);
        }
    }

    private boolean resumeOnRecovery() {
        IProcessManagerService service = (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
        return !Boolean.parseBoolean(service.getProperties().getProperty("no.retry.on.recovery"));
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (WorkflowProcessCache)ServiceRegistry.getDefault().lookup("Process Cache");
    }
}

