/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.TypeConversionException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class DatatypeConverter {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String TIME_FORMAT_LONG = "dd'T'HH:mm:ss";

    public Object convert(Object input, Datatype type) throws TypeConversionException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        Cloneable ret = input.toString();
        try {
            switch (type) {
                case INT: {
                    ret = Integer.valueOf(input.toString());
                    break;
                }
                case BOOLEAN: {
                    ret = Boolean.valueOf(input.toString());
                    break;
                }
                case DATE: {
                    ret = this.dateFormatterFor(DATE_FORMAT).parse(input.toString());
                    break;
                }
                case DURATION: {
                    try {
                        this.dateFormatterFor(TIME_FORMAT).parse(input.toString());
                    }
                    catch (ParseException e) {
                        this.dateFormatterFor(TIME_FORMAT_LONG).parse(input.toString());
                    }
                    break;
                }
                case LIST: {
                    ret = this.toList(input);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TypeConversionException("Failed to convert " + input + " to type " + (Object)((Object)type), e);
        }
        return ret;
    }

    private ArrayList<?> toList(Object input) {
        if (input instanceof String) {
            if (input.toString().isEmpty()) {
                return null;
            }
            String[] strings = ((String)String.class.cast(input)).split(",");
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = strings[i].trim();
            }
            return new ArrayList<String>(Arrays.asList(strings));
        }
        return (ArrayList)input;
    }

    private DateFormat dateFormatterFor(String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        f.setLenient(false);
        return f;
    }
}

