/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.TypeConversionException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class DatatypeConverter {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String TIME_FORMAT_LONG = "dd'T'HH:mm:ss";

    public static Object convert(Object input, Datatype type) throws TypeConversionException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        Object ret = input.toString();
        try {
            switch (type) {
                case INT: {
                    ret = Integer.valueOf(input.toString());
                    break;
                }
                case LONG: {
                    ret = Long.valueOf(input.toString());
                    break;
                }
                case DOUBLE: {
                    ret = Double.valueOf(input.toString());
                    break;
                }
                case FLOAT: {
                    ret = Float.valueOf(input.toString());
                    break;
                }
                case BYTE: {
                    ret = Byte.valueOf(input.toString());
                    break;
                }
                case CHAR: {
                    ret = Character.valueOf(input.toString().charAt(0));
                    break;
                }
                case BOOLEAN: {
                    ret = Boolean.valueOf(input.toString());
                    break;
                }
                case DATE: {
                    ret = DatatypeConverter.dateFormatterFor(DATE_FORMAT).parse(input.toString());
                    break;
                }
                case DURATION: {
                    try {
                        DatatypeConverter.dateFormatterFor(TIME_FORMAT).parse(input.toString());
                    }
                    catch (ParseException e) {
                        DatatypeConverter.dateFormatterFor(TIME_FORMAT_LONG).parse(input.toString());
                    }
                    break;
                }
                case LIST: {
                    ret = DatatypeConverter.toList(input);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TypeConversionException("Failed to convert " + input + " to type " + (Object)((Object)type), e);
        }
        return ret;
    }

    public static String convertToString(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return DatatypeConverter.convert(input, Datatype.STRING).toString();
    }

    public static Integer convertToInt(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return ((Number)DatatypeConverter.convert(input, Datatype.INT)).intValue();
    }

    public static Long convertToLong(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return ((Number)DatatypeConverter.convert(input, Datatype.LONG)).longValue();
    }

    public static Double convertToDouble(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return ((Number)DatatypeConverter.convert(input, Datatype.DOUBLE)).doubleValue();
    }

    public static Float convertToFloat(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return Float.valueOf(((Number)DatatypeConverter.convert(input, Datatype.FLOAT)).floatValue());
    }

    public static Byte convertToByte(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return ((Number)DatatypeConverter.convert(input, Datatype.BYTE)).byteValue();
    }

    public static Character convertToChar(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return (Character)DatatypeConverter.convert(input, Datatype.CHAR);
    }

    public static Boolean convertToBoolean(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return (Boolean)DatatypeConverter.convert(input, Datatype.BOOLEAN);
    }

    public static Date convertToDate(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return (Date)DatatypeConverter.convert(input, Datatype.DATE);
    }

    public static List<?> convertToList(Object input) throws TypeConversionException {
        if (input == null) {
            return null;
        }
        return (List)DatatypeConverter.convert(input, Datatype.LIST);
    }

    private static List<?> toList(Object input) {
        if (input instanceof String) {
            if (input.toString().isEmpty()) {
                return null;
            }
            String[] strings = ((String)String.class.cast(input)).split(",");
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = strings[i].trim();
            }
            return new ArrayList<String>(Arrays.asList(strings));
        }
        return (List)input;
    }

    private static DateFormat dateFormatterFor(String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        f.setLenient(false);
        return f;
    }
}

