/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.proxy;

import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.WFSVariableInstance;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowProcessNote;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.proxy.WorkflowTemplateProxy;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.RuntimeAction;
import org.jbpm.graph.exe.Token;
import org.jbpm.logging.exe.LoggingInstance;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class WorkflowProcessProxy
extends WorkflowProcess {
    private static final long serialVersionUID = -4834479512680684726L;
    private final long processId;
    private final ProcessPriority processPriority;
    private final WorkflowTemplate template;
    private final String processString;
    private final String logLevel;

    public WorkflowProcessProxy(WorkflowProcess process) {
        this.processId = process.getId();
        this.processPriority = process.getPriority();
        this.processString = process.toString();
        this.logLevel = (String)process.getContextInstance().getVariable(LogLevel.LEVEL);
        this.template = new WorkflowTemplateProxy(process.getProcessDefinition());
    }

    public long getId() {
        return this.processId;
    }

    @Override
    public ProcessPriority getPriority() {
        return this.processPriority;
    }

    @Override
    public WorkflowTemplate getProcessDefinition() {
        return this.template;
    }

    @Override
    public LogLevel getLogLevel() {
        if (this.logLevel == null) {
            return LogLevel.ALL;
        }
        return LogLevel.valueOf(this.logLevel);
    }

    @Override
    public String toString() {
        return this.processString;
    }

    @Override
    public CustomToken getRootToken() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public CustomToken getSuperProcessToken() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public void setPriority(ProcessPriority priority) {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public WorkflowProcessNote getNote() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public void setNote(WorkflowProcessNote note) {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public Set<WFSVariableInstance> getVariables() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public void addProtectionKey(ProtectionKey key) {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public boolean isActive() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public void delete() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public void lock() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public void unlock() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public boolean getCanBeDeleted() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public boolean getCanBePaused() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public boolean getCanBeResumed() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public boolean getCanBeRetried() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public boolean getCanBeCancelled() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public boolean getCanBeRestarted() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public boolean hasParent() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public List<CustomToken> findAllTokens() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public void end() {
        throw new RuntimeException("Operation not permitted");
    }

    @Override
    public void addRuntimeActions() {
        throw new RuntimeException("Operation not permitted");
    }

    public ModuleInstance addInstance(ModuleInstance moduleInstance) {
        throw new RuntimeException("Operation not permitted");
    }

    public ModuleInstance removeInstance(ModuleInstance moduleInstance) {
        throw new RuntimeException("Operation not permitted");
    }

    public ModuleInstance getInstance(Class clazz) {
        throw new RuntimeException("Operation not permitted");
    }

    public ContextInstance getContextInstance() {
        throw new RuntimeException("Operation not permitted");
    }

    public TaskMgmtInstance getTaskMgmtInstance() {
        throw new RuntimeException("Operation not permitted");
    }

    public LoggingInstance getLoggingInstance() {
        throw new RuntimeException("Operation not permitted");
    }

    public void signal() {
        throw new RuntimeException("Operation not permitted");
    }

    public void signal(String transitionName) {
        throw new RuntimeException("Operation not permitted");
    }

    public void signal(Transition transition) {
        throw new RuntimeException("Operation not permitted");
    }

    public void suspend() {
        throw new RuntimeException("Operation not permitted");
    }

    public void resume() {
        throw new RuntimeException("Operation not permitted");
    }

    public RuntimeAction addRuntimeAction(RuntimeAction runtimeAction) {
        throw new RuntimeException("Operation not permitted");
    }

    public RuntimeAction removeRuntimeAction(RuntimeAction runtimeAction) {
        throw new RuntimeException("Operation not permitted");
    }

    public List getRuntimeActions() {
        throw new RuntimeException("Operation not permitted");
    }

    public boolean hasEnded() {
        throw new RuntimeException("Operation not permitted");
    }

    public boolean isTerminatedImplicitly() {
        throw new RuntimeException("Operation not permitted");
    }

    public Token findToken(String tokenPath) {
        throw new RuntimeException("Operation not permitted");
    }

    public Collection<?> removeCascadeProcessInstances() {
        throw new RuntimeException("Operation not permitted");
    }

    public Date getStart() {
        throw new RuntimeException("Operation not permitted");
    }

    public Date getEnd() {
        throw new RuntimeException("Operation not permitted");
    }

    public Map<?, ?> getInstances() {
        throw new RuntimeException("Operation not permitted");
    }

    public void setSuperProcessToken(Token superProcessToken) {
        throw new RuntimeException("Operation not permitted");
    }

    public boolean isSuspended() {
        throw new RuntimeException("Operation not permitted");
    }

    public int getVersion() {
        throw new RuntimeException("Operation not permitted");
    }

    public void setVersion(int version) {
        throw new RuntimeException("Operation not permitted");
    }

    public void setEnd(Date end) {
        throw new RuntimeException("Operation not permitted");
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        throw new RuntimeException("Operation not permitted");
    }

    public void setRootToken(Token rootToken) {
        throw new RuntimeException("Operation not permitted");
    }

    public void setStart(Date start) {
        throw new RuntimeException("Operation not permitted");
    }
}

