/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.exe.Transitions;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskController;

public class AssignNode
extends TaskNode {
    private static final long serialVersionUID = -1861834857409581767L;
    private static final Logger LOGGER = Logger.getLogger(AssignNode.class);

    public Transition getDefaultLeavingTransition() {
        Transition leaving = Transitions.createDefaultLeavingTransition((Node)this);
        if (leaving != null) {
            return leaving;
        }
        return super.getDefaultLeavingTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context) {
        if (this.getTasks() == null || this.getTasks().isEmpty()) {
            return;
        }
        CustomToken token = (CustomToken)context.getToken();
        if (token.getStatus() != ProcessStatus.RUNNING) {
            throw new InvalidProcessStateException(token.toString());
        }
        WorkflowProcess process = token.getProcessInstance();
        LOGGER.info((Object)(token + " (" + this.name + ")"));
        token.acquire();
        Task task = (Task)this.getTasks().iterator().next();
        TaskController controller = task.getTaskController();
        process.lock();
        try {
            for (TaskVariable variable : controller.getVariableAccesses()) {
                Object value = context.getVariable(variable.getInitialValue());
                context.setVariable(variable.getVariableName(), value);
            }
        }
        catch (Throwable t) {
            try {
                this.raiseException(t, context);
            }
            catch (DelegationException e) {
                LOGGER.warn((Object)(token + ", no exception handler defined for template - " + this.processDefinition.getName()), t);
                token.fail(e);
            }
        }
        finally {
            process.unlock();
        }
        if (token.getStatus() == ProcessStatus.BUSY) {
            token.release();
            this.leave(context);
        }
    }
}

