/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.license;

import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.internal.DistributedCache;
import com.tandbergtv.workflow.core.service.internal.DistributedLock;
import com.tandbergtv.workflow.core.service.lock.IDistributedLock;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.license.ILicenseService;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;

public class ResourceManagementLicenseService
extends ResourceManagementService
implements ILicenseService {
    private final Integer maxSystemResourceCount;
    private final Integer maxHumanResourceCount;
    private IDistributedCache<Serializable> licenseCache;
    private IDistributedLock lockingService;
    private static final String CACHE_NAME = "WFS:ResourceLicenseCache";
    private static final String SYSTEM_RESOURCE_COUNT_KEY = "SystemResourceCount";
    private static final String HUMAN_RESOURCE_COUNT_KEY = "HumanResourceCount";

    public ResourceManagementLicenseService(int maxSystemResourceCount, int maxHumanResourceCount) {
        this.maxSystemResourceCount = maxSystemResourceCount;
        this.maxHumanResourceCount = maxHumanResourceCount;
    }

    @Override
    public int getMaximumSystemResourceCount() {
        return this.maxSystemResourceCount;
    }

    @Override
    public int getSystemResourceCount() {
        return this.getCount(SYSTEM_RESOURCE_COUNT_KEY, this.getMaximumSystemResourceCount());
    }

    @Override
    public void setSystemResourceCount(int value) {
        this.setCount(SYSTEM_RESOURCE_COUNT_KEY, value);
    }

    @Override
    public boolean isSystemResourceCountInitialized() {
        return this.isCountInitialized(SYSTEM_RESOURCE_COUNT_KEY);
    }

    @Override
    public boolean tryIncrementSystemResourceCount() {
        return this.tryIncrementCount(SYSTEM_RESOURCE_COUNT_KEY, this.getMaximumSystemResourceCount());
    }

    @Override
    public void decrementSystemResourceCount() {
        this.decrementCount(SYSTEM_RESOURCE_COUNT_KEY);
    }

    @Override
    public int getMaximumHumanResourceCount() {
        return this.maxHumanResourceCount;
    }

    @Override
    public int getHumanResourceCount() {
        return this.getCount(HUMAN_RESOURCE_COUNT_KEY, this.getMaximumHumanResourceCount());
    }

    @Override
    public void setHumanResourceCount(int value) {
        this.setCount(HUMAN_RESOURCE_COUNT_KEY, value);
    }

    @Override
    public boolean isHumanResourceCountInitialized() {
        return this.isCountInitialized(HUMAN_RESOURCE_COUNT_KEY);
    }

    @Override
    public boolean tryIncrementHumanResourceCount() {
        return this.tryIncrementCount(HUMAN_RESOURCE_COUNT_KEY, this.getMaximumHumanResourceCount());
    }

    @Override
    public void decrementHumanResourceCount() {
        this.decrementCount(HUMAN_RESOURCE_COUNT_KEY);
    }

    @Override
    public boolean isHumanResource(String resourceTypeSystemId) {
        return "04".equals(resourceTypeSystemId);
    }

    private Integer getIntegerValue(String key) {
        return (Integer)this.licenseCache.get((Serializable)((Object)key));
    }

    private void setIntegerValue(String key, int value) {
        this.licenseCache.add((Serializable)((Object)key), (Object)new Integer(value));
    }

    private boolean isCountInitialized(String key) {
        return this.getIntegerValue(key) != null;
    }

    private int getCount(String key, int defaultValue) {
        Integer value = this.getIntegerValue(key);
        return value == null ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCount(String key, int value) {
        Lock lock = this.getLock(key);
        lock.lock();
        try {
            this.setIntegerValue(key, value);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryIncrementCount(String key, int maxValue) {
        Lock lock = this.getLock(key);
        lock.lock();
        try {
            Integer value = this.getIntegerValue(key);
            if (value != null && value < maxValue) {
                int intValue = value + 1;
                this.setIntegerValue(key, intValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementCount(String key) {
        Lock lock = this.getLock(key);
        lock.lock();
        try {
            Integer value = this.getIntegerValue(key);
            if (value != null) {
                int intValue = value - 1;
                if (intValue < 0) {
                    intValue = 0;
                }
                this.setIntegerValue(key, intValue);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private Lock getLock(String key) {
        return this.lockingService.getLock((Serializable)((Object)key));
    }

    @Override
    public void start() {
        this.lockingService = new DistributedLock();
        this.lockingService.start();
        this.licenseCache = new DistributedCache(CACHE_NAME);
        this.licenseCache.start();
    }

    @Override
    public void stop() {
        this.licenseCache.stop();
        this.licenseCache = null;
        this.lockingService.stop();
        this.lockingService = null;
    }
}

