/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.container;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceEntity;
import com.tandbergtv.workflow.resourcemanager.internal.container.IResourceManagementContainer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BaseContainer<T extends ResourceEntity>
implements IResourceManagementContainer<T> {
    private static final long serialVersionUID = -2081242661680226795L;
    private ServiceRegistry registry;
    private T entity;
    private boolean isStarted = false;
    private boolean isStopped = false;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public BaseContainer(T entity) {
        this.entity = entity;
    }

    public ServiceRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(ServiceRegistry registry) {
        this.registry = registry;
    }

    @Override
    public T getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(T entity) {
        this.entity = entity;
        this.updateEntity();
    }

    @Override
    public boolean updateEntity() {
        return this.updateEntity(false);
    }

    @Override
    public boolean updateEntity(boolean persist) {
        if (!this.isStopped()) {
            this.writeToDistributedCache();
            if (persist) {
                this.writeToPersistenceStore();
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        this.doStart();
        this.isStarted = true;
    }

    @Override
    public void stop() {
        this.doStop();
        this.isStopped = true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Lock getReadLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock getWriteLock() {
        return this.lock.writeLock();
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public boolean isStopped() {
        return this.isStopped;
    }

    @Override
    public boolean isRunning() {
        return this.isStarted && !this.isStopped;
    }

    protected abstract void doStart();

    protected abstract void doStop();

    protected abstract void writeToDistributedCache();

    protected abstract void writeToPersistenceStore();

    protected <S extends Service> S getService(String name) {
        return (S)this.registry.lookup(name);
    }

    protected <S extends Service> S getService(Class<S> clazz) {
        return (S)((Service)this.registry.lookup(clazz));
    }

    public boolean equals(Object obj) {
        if (obj instanceof IResourceManagementContainer) {
            IResourceManagementContainer other = (IResourceManagementContainer)obj;
            return this.getEntity().equals(other.getEntity());
        }
        return false;
    }

    public int hashCode() {
        return this.getEntity().hashCode();
    }
}

