/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.event;

import com.tandbergtv.workflow.resourcemanager.internal.event.HandleEventCallable;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HandleEventCallableQueue {
    private final String queueId;
    private final Queue<HandleEventCallable> taskQueue;
    private final Lock lock = new ReentrantLock();
    private HandleEventCallable processingCallable = null;
    private boolean disposed = false;

    public HandleEventCallableQueue(String queueId) {
        this.queueId = queueId;
        this.taskQueue = new LinkedList<HandleEventCallable>();
    }

    public String getQueueId() {
        return this.queueId;
    }

    public void submit(HandleEventCallable callable) {
        if (this.isDisposed()) {
            String msg = "Cannot queue event task since queue[" + this.queueId + "] is disposed.";
            throw new RuntimeException(msg);
        }
        this.taskQueue.offer(callable);
    }

    public HandleEventCallable getTaskForProcessing() {
        if (this.isDisposed()) {
            String msg = "Cannot get task for processing since queue[" + this.queueId + "] is disposed.";
            throw new RuntimeException(msg);
        }
        if (this.processingCallable == null) {
            this.processingCallable = this.taskQueue.poll();
            return this.processingCallable;
        }
        return null;
    }

    public boolean notifyCallableCompleted(HandleEventCallable callable) {
        if (this.processingCallable == callable) {
            this.processingCallable = null;
            return true;
        }
        return false;
    }

    public boolean isTaskProcessing() {
        return this.processingCallable != null;
    }

    public HandleEventCallable getProcessingTask() {
        return this.processingCallable;
    }

    public boolean isQueueEmpty() {
        return this.taskQueue.peek() == null;
    }

    public boolean isBusy() {
        return this.isTaskProcessing() || !this.isQueueEmpty();
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Lock getLock() {
        return this.lock;
    }

    public String toString() {
        return "[" + this.queueId + "]";
    }
}

