/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.util;

import com.tandbergtv.workflow.resourcemanager.entities.ResourceConnectionType;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import javax.mail.internet.InternetAddress;

public final class ResourceConnectionTypeValidator {
    private ResourceConnectionTypeValidator() {
    }

    public static boolean validateConnectionString(String connectionString, ResourceConnectionType connectionType) {
        if (connectionString == null || connectionString.trim().length() == 0) {
            return false;
        }
        boolean result = false;
        switch (connectionType) {
            case URL: {
                result = ResourceConnectionTypeValidator.validateURL(connectionString);
                break;
            }
            case EMAIL: {
                result = ResourceConnectionTypeValidator.validateEmail(connectionString);
                break;
            }
            case IP_PORT: {
                result = ResourceConnectionTypeValidator.validateIPPort(connectionString);
                break;
            }
            default: {
                return false;
            }
        }
        return result;
    }

    private static boolean validateURL(String url) {
        try {
            URI connectionURI = new URI(url);
            connectionURI.toURL();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static boolean validateEmail(String email) {
        try {
            new InternetAddress(email, true);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static boolean validateIPPort(String ipPort) {
        int index = ipPort.lastIndexOf(":");
        String ip = index != -1 ? ipPort.substring(0, index) : ipPort;
        String portValue = index != -1 ? ipPort.substring(index + 1) : null;
        try {
            InetAddress ipAddress = InetAddress.getByName(ip);
            if (portValue != null) {
                int port = Integer.valueOf(portValue);
                new InetSocketAddress(ipAddress, port);
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

