/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resourcegroup;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.IInternalResourceService;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.internal.resourcegroup.ResourceGroupServiceCallable;
import java.util.List;

public class SetResourceGroupAllocatableCallable
extends ResourceGroupServiceCallable<List<ResourceGroup>> {
    private static final long serialVersionUID = 3812658902423694920L;
    private long resourceGroupId;
    private boolean allocatable;

    public SetResourceGroupAllocatableCallable(long resourceTypeId, long resourceGroupId, boolean allocatable) {
        super(resourceTypeId);
        this.resourceGroupId = resourceGroupId;
        this.allocatable = allocatable;
    }

    @Override
    protected List<ResourceGroup> performServiceTask() throws Exception {
        IInternalResourceService internalResourceService = (IInternalResourceService)ServiceRegistry.getDefault().lookup(IInternalResourceService.class);
        if (this.allocatable) {
            internalResourceService.remove(this.resourceGroupId);
        } else {
            internalResourceService.add(this.resourceGroupId);
        }
        return this.getService().setResourceGroupQueueAllocatability(this.resourceGroupId, this.allocatable);
    }

    @Override
    public Long getKey() {
        return null;
    }
}

