/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.container;

import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.event.SimulatedPartitionEvent;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.event.IEventHandler;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ResourceManagementContainerMonitor
extends ResourceManagementService
implements IResourceManagementService {
    private static final Logger LOGGER = Logger.getLogger(ResourceManagementContainerMonitor.class);
    private static final String SERVICE_NAME = "Container Cache Monitor";
    private ISchedulerService<Void> scheduler;
    private boolean run = true;
    private Set<KeyData> missingKeys;
    private Set<KeyData> extraKeys;
    private final long monitorStartDelay;
    private final long monitorFrequency;

    public ResourceManagementContainerMonitor(int monitorStartDelay, int monitorFrequency) {
        this.monitorStartDelay = (long)monitorStartDelay * 1000L;
        this.monitorFrequency = (long)monitorFrequency * 1000L;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public void start() {
        this.run = true;
        this.scheduler = new Scheduler("resource-cacheMonitor");
        this.scheduler.start();
        this.scheduler.schedule((Callable)new MonitorCacheCallable(), this.monitorStartDelay);
    }

    @Override
    public void stop() {
        this.run = false;
        this.scheduler.stop();
        this.scheduler = null;
    }

    private void monitorCache() {
        IDistributedCache typeCache = (IDistributedCache)this.getService("WFS:ResourceTypeCache");
        ICacheService typeContainerCache = (ICacheService)this.getService("ResourceTypeContainerCache");
        Collection distributedKeys = typeCache.localKeySet();
        Collection localKeys = typeContainerCache.getKeys();
        TreeSet<KeyData> missingLocalKeys = new TreeSet<KeyData>();
        for (Serializable distributedKey : distributedKeys) {
            if (localKeys.contains(distributedKey)) continue;
            missingLocalKeys.add(new KeyData(distributedKey));
        }
        TreeSet<KeyData> extraLocalKeys = new TreeSet<KeyData>();
        for (Serializable localKey : localKeys) {
            if (distributedKeys.contains(localKey)) continue;
            extraLocalKeys.add(new KeyData(localKey));
        }
        if (missingLocalKeys.size() > 0 || extraLocalKeys.size() > 0) {
            LOGGER.warn((Object)("Caching error detected for resource types, missing keys: " + missingLocalKeys + " and extra keys: " + extraLocalKeys));
        }
        if (this.extraKeys != null) {
            this.extraKeys.retainAll(extraLocalKeys);
            this.simulatePartitionEvent(this.extraKeys, false);
        }
        if (this.missingKeys != null) {
            this.missingKeys.retainAll(missingLocalKeys);
            this.simulatePartitionEvent(this.missingKeys, true);
        }
        this.missingKeys = missingLocalKeys;
        this.extraKeys = extraLocalKeys;
    }

    private void simulatePartitionEvent(Set<KeyData> keyDataSet, boolean completed) {
        if (keyDataSet == null || keyDataSet.size() == 0) {
            return;
        }
        HashMap<Integer, HashSet<Long>> partitionMap = new HashMap<Integer, HashSet<Long>>();
        for (KeyData keyData : keyDataSet) {
            HashSet<Long> keySet = (HashSet<Long>)partitionMap.get(keyData.partitionId);
            if (keySet == null) {
                keySet = new HashSet<Long>();
                partitionMap.put(keyData.partitionId, keySet);
            }
            keySet.add(keyData.key);
        }
        ICacheService<ResourceType> cache = this.getResourceTypeCache();
        for (Integer partitionId : partitionMap.keySet()) {
            Set keySet = (Set)partitionMap.get(partitionId);
            SimulatedPartitionEvent event = new SimulatedPartitionEvent(cache, partitionId, keySet, completed);
            String type = completed ? "completed" : "started";
            LOGGER.warn((Object)("Simulating partition event(" + type + ") for partition[" + partitionId + "] - " + keySet));
            this.getEventHandler().handleEvent((WorkflowEvent)event);
        }
    }

    private ICacheService<ResourceType> getResourceTypeCache() {
        return (ICacheService)this.getService("WFS:ResourceTypeCache");
    }

    private IEventHandler getEventHandler() {
        return (IEventHandler)this.getService("ResourceManagementDistributedEventHandler");
    }

    private static final class KeyData
    implements Comparable<KeyData> {
        private Long key;
        private int partitionId;
        private String memberName;

        public KeyData(Serializable key) {
            this.key = (Long)key;
            this.partitionId = Cluster.getPartitionId((Object)key);
            this.memberName = Cluster.getMemberName((Object)key);
        }

        @Override
        public int compareTo(KeyData o) {
            return this.key.compareTo(o.key);
        }

        public String toString() {
            return this.key.toString() + "[" + this.memberName + ", " + this.partitionId + "]";
        }

        public boolean equals(Object obj) {
            if (obj instanceof KeyData) {
                return this.key.equals(((KeyData)obj).key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode() + 54;
        }
    }

    private class MonitorCacheCallable
    implements Callable<Void> {
        private MonitorCacheCallable() {
        }

        @Override
        public Void call() throws Exception {
            while (ResourceManagementContainerMonitor.this.run) {
                block5: {
                    try {
                        ResourceManagementContainerMonitor.this.monitorCache();
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) break block5;
                        LOGGER.error((Object)"Failure while monitoring resource management local cache.", (Throwable)e);
                    }
                }
                try {
                    if (!ResourceManagementContainerMonitor.this.run) continue;
                    Thread.sleep(ResourceManagementContainerMonitor.this.monitorFrequency);
                }
                catch (Exception e) {
                    LOGGER.debug((Object)("Interrupted while sleeping, error: " + e.getLocalizedMessage()), (Throwable)e);
                }
            }
            return null;
        }
    }
}

