/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.hazelcast.partition.MigrationEvent;
import com.hazelcast.partition.MigrationListener;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.internal.AbstractCompositeCache;
import com.tandbergtv.workflow.core.service.internal.DistributedCache;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class CoherentCache<T>
extends AbstractCompositeCache<T> {
    public CoherentCache(String name, int size) {
        super(name, size);
    }

    @Override
    public void add(Serializable key, T entity) {
        if (!Cluster.owner(key)) {
            throw new RuntimeException("This node cannot update key " + key);
        }
        super.add(key, entity);
    }

    @Override
    public void remove(Serializable key) {
        if (!Cluster.owner(key)) {
            throw new RuntimeException("This node cannot remove key " + key);
        }
        super.remove(key);
    }

    protected Set<Serializable> removeKeysInPartition(int partitionId) {
        HashSet<Serializable> set = new HashSet<Serializable>();
        for (Serializable key : this.cache.getKeys()) {
            if (Cluster.getPartitionId(key) != partitionId) continue;
            this.cache.remove(key);
            set.add(key);
        }
        return set;
    }

    protected Set<Serializable> syncKeysInPartition(int partitionId) {
        HashSet<Serializable> set = new HashSet<Serializable>();
        for (Serializable key : this.localKeySet()) {
            if (Cluster.getPartitionId(key) != partitionId || this.cache.get(key) != null) continue;
            this.cache.add(key, this.get(key));
            set.add(key);
        }
        return set;
    }

    @Override
    protected MigrationListener getMigrationListener() {
        return new CoherentCacheMigrationListener(this);
    }

    public class CoherentCacheMigrationListener
    extends DistributedCache.CacheKeyMigrationListener {
        public CoherentCacheMigrationListener(IDistributedCache<T> cache) {
            super(cache);
        }

        @Override
        public void migrationStarted(MigrationEvent event) {
            if (this.wasPreviousOwner(event)) {
                CoherentCache.this.removeKeysInPartition(event.getPartitionId());
            }
        }

        @Override
        public void migrationCompleted(MigrationEvent event) {
            if (this.isNewOwner(event)) {
                CoherentCache.this.syncKeysInPartition(event.getPartitionId());
            }
        }
    }
}

