/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.process.search;

import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.test.NormalTestBase;
import com.tandbergtv.workflow.test.util.ProcessUtils;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class SearchTest2
extends NormalTestBase {
    private Set<WorkflowProcess> set = new HashSet<WorkflowProcess>();
    private String uuid = "";

    @AfterClass
    void teardown() throws Exception {
        IProcessManagerService service = ProcessUtils.getProcessManager();
        for (WorkflowProcess p : this.set) {
            service.delete(p);
        }
        this.uuid = "";
    }

    @BeforeClass
    void setup() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.uuid = UUID.randomUUID().toString();
        params.put("titleBrief", this.uuid);
        for (int i = 0; i < 25; ++i) {
            WorkflowProcess wp = this.run("search-workorder-template", params);
            SearchTest2.assertNotNull((Object)wp);
            this.set.add(wp);
        }
        Thread.sleep(10000L);
    }

    @Test
    void testSearchSortByIdAscending() {
        SearchCriteria c = this.defaultCriteria();
        List<WFSearchResult> results = this.search(this.setSort(c, "id", SortingOrder.ASCENDING));
        this.assertIdSortAscending(results);
    }

    @Test
    void testSearchSortByIdDescending() {
        SearchCriteria c = this.defaultCriteria();
        List<WFSearchResult> results = this.search(this.setSort(c, "id", SortingOrder.DESCENDING));
        this.assertIdSortDescending(results);
    }

    @Test
    void testSearchSortByStartTimeAscending() {
        SearchCriteria c = this.defaultCriteria();
        List<WFSearchResult> results = this.search(this.setSort(c, "startTime", SortingOrder.ASCENDING));
        this.assertStartTimeSortAscending(results);
    }

    @Test
    void testSearchSortByStartTimeDescending() {
        SearchCriteria c = this.defaultCriteria();
        List<WFSearchResult> results = this.search(this.setSort(c, "startTime", SortingOrder.DESCENDING));
        this.assertStartTimeSortDescending(results);
    }

    @Test
    void testSearchGoTo() {
        SearchCriteria c = this.defaultCriteria();
        List<WFSearchResult> results = this.search(this.addPagingParameter(c, 3, 10));
        SearchTest2.assertEquals((int)results.size(), (int)5);
    }

    @Test
    void testSearchRowLimit10() {
        SearchCriteria c = this.defaultCriteria();
        List<WFSearchResult> results = this.search(this.addPagingParameter(c, 1, 10));
        SearchTest2.assertEquals((int)results.size(), (int)10);
    }

    @Test
    void testSearchRowLimit25() {
        SearchCriteria c = this.defaultCriteria();
        List<WFSearchResult> results = this.search(this.addPagingParameter(c, 1, 25));
        SearchTest2.assertEquals((int)results.size(), (int)25);
    }

    void assertIdSortAscending(List<WFSearchResult> results) {
        long prev = 0L;
        boolean sorted = true;
        for (WFSearchResult result : results) {
            long current = result.getProcessId();
            if (prev > current) {
                sorted = false;
                break;
            }
            prev = current;
        }
        SearchTest2.assertTrue((boolean)sorted);
    }

    void assertIdSortDescending(List<WFSearchResult> results) {
        long prev = results.get(0).getProcessId();
        boolean sorted = true;
        for (WFSearchResult result : results) {
            long current = result.getProcessId();
            if (prev < current) {
                sorted = false;
                break;
            }
            prev = current;
        }
        SearchTest2.assertTrue((boolean)sorted);
    }

    void assertStartTimeSortAscending(List<WFSearchResult> results) {
        Date prev = results.get(0).getToken().getStartTime();
        boolean sorted = true;
        for (WFSearchResult result : results) {
            Date current = result.getToken().getStartTime();
            if (prev.compareTo(current) > 0) {
                sorted = false;
                break;
            }
            prev = current;
        }
        SearchTest2.assertTrue((boolean)sorted);
    }

    void assertStartTimeSortDescending(List<WFSearchResult> results) {
        Date prev = results.get(0).getToken().getStartTime();
        boolean sorted = true;
        for (WFSearchResult result : results) {
            Date current = result.getToken().getStartTime();
            if (prev.compareTo(current) < 0) {
                sorted = false;
                break;
            }
            prev = current;
        }
        SearchTest2.assertTrue((boolean)sorted);
    }

    SearchCriteria defaultCriteria() {
        SearchCriteria c = new SearchCriteria();
        c.addParameter((SearchParameterBase)new ValueParameter("titleBrief", SearchType.STRING, true, (Object)this.uuid, SearchOperator.EQUAL));
        return c;
    }

    SearchCriteria setSort(SearchCriteria c, String sortColumn, SortingOrder sortOrder) {
        c.addParameter((SearchParameterBase)new SortParameter(sortColumn, sortOrder));
        return c;
    }

    SearchCriteria addPagingParameter(SearchCriteria c, int pageNumber, int recordsCount) {
        c.setRecordsCount(recordsCount);
        c.setStartingRecordNumber((pageNumber - 1) * recordsCount);
        return c;
    }

    List<WFSearchResult> search(SearchCriteria criteria) {
        return this.getService().expressSearch(criteria);
    }

    IProcessSearchService getService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }
}

