/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.unit.test;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.elasticsearch.WFSElasticSearchService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.rest.services.internal.ProcessesResource;
import com.tandbergtv.workflow.rest.services.test.RESTUtil;
import com.tandbergtv.workflow.unit.test.RESTMockUtil;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ServiceRegistry.class})
public class ProcessesStatisticsUnitTest {
    private static final String BASE_API_PATH = "/processes/statistics";
    private static final String STAUS_CREATED = "created";
    private static final String STAUS_BUSY = "busy";
    private static final String STAUS_RUNNING = "running";
    private static final String STAUS_PAUSED = "paused";
    private static final String STAUS_COMPLETED = "completed";
    private static final String STAUS_CANCELLED = "cancelled";
    private static final String STAUS_BRANCHED = "branched";
    private static final String STAUS_QUEUED = "queued";
    private static final String STAUS_ERROR = "error";
    private static final int BUSY_PROCESSES_COUNT = 6;
    private static final int PROCESSES_COUNT = 3;
    private static final String INVALID_START_DATE = "start=abc";
    private static IProcessSearchService processSearchService;
    private static ServiceRegistry registry;
    private static RESTMockUtil restUtil;

    public ProcessesStatisticsUnitTest() {
        restUtil = new RESTMockUtil(ProcessesResource.class);
    }

    @Before
    public void setup() throws Exception {
        registry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        processSearchService = (IProcessSearchService)Mockito.mock(WFSElasticSearchService.class);
        PowerMockito.mockStatic(ServiceRegistry.class, (Class[])new Class[0]);
        Mockito.when((Object)ServiceRegistry.getDefault()).thenReturn((Object)registry);
        Mockito.when((Object)registry.lookup(IProcessSearchService.class)).thenReturn((Object)processSearchService);
    }

    @Test
    public void testProcessStatistics() throws Exception {
        Mockito.when((Object)processSearchService.expressCount((SearchCriteria)Matchers.any(SearchCriteria.class))).thenReturn((Object)3);
        Map<String, Object> response = restUtil.getResponseMap(BASE_API_PATH);
        Assert.assertEquals((Object)String.valueOf(3), (Object)response.get(STAUS_PAUSED));
        Assert.assertEquals((Object)String.valueOf(3), (Object)response.get(STAUS_CANCELLED));
        Assert.assertEquals((Object)String.valueOf(3), (Object)response.get(STAUS_COMPLETED));
        Assert.assertEquals((Object)String.valueOf(3), (Object)response.get(STAUS_BRANCHED));
        Assert.assertEquals((Object)String.valueOf(3), (Object)response.get(STAUS_QUEUED));
        Assert.assertEquals((Object)String.valueOf(3), (Object)response.get(STAUS_ERROR));
        Assert.assertEquals((Object)String.valueOf(6), (Object)response.get(STAUS_BUSY));
        Assert.assertEquals((Object)String.valueOf(3), (Object)response.get(STAUS_CREATED));
        Assert.assertEquals((Object)"0", (Object)response.get(STAUS_RUNNING));
    }

    @Test
    public void testStatisticsWithInvalidStartDateParam() throws Exception {
        Assert.assertEquals((long)400L, (long)restUtil.executeGet("/processes/statistics?start=abc", RESTUtil.setDefaultHeaders()).getStatus());
    }

    @Test
    public void testWhenNoVersionHeaderIsSent() throws Exception {
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(BASE_API_PATH, new HashMap<String, String>()).getStatus());
    }

    @Test
    public void testInvalidVersionHeader() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-API-Version", "2");
        Assert.assertEquals((long)400L, (long)restUtil.executeGet(BASE_API_PATH, headers).getStatus());
    }
}

