/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class HostnameResolver {
    private static Logger logger = Logger.getLogger(HostnameResolver.class);

    public static String replaceURLWithIP(String urlValue) throws MalformedURLException, UnknownHostException {
        URL url = new URL(urlValue);
        List<String> addresses = HostnameResolver.getHostAddress();
        String ip = null;
        ip = addresses.size() > 1 ? HostnameResolver.getIPByHostname(url.getHost()) : addresses.get(0);
        URL updatedUrl = new URL(url.getProtocol(), ip, url.getPort(), url.getFile());
        return updatedUrl.toExternalForm();
    }

    private static List<String> getHostAddress() {
        ArrayList<String> addresses = new ArrayList<String>();
        try {
            InetAddress localhost = InetAddress.getByName("localhost");
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip instanceof Inet6Address) continue;
                    logger.debug((Object)("Ethernet if " + ni.getDisplayName() + " IP " + ip.getHostAddress()));
                    if (ip.getHostAddress().equals(localhost.getHostAddress())) continue;
                    addresses.add(ip.getHostAddress());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return addresses;
    }

    private static String getIPByHostname(String hostname) throws UnknownHostException {
        String ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(hostname).getHostAddress();
        }
        catch (UnknownHostException ex) {
            logger.error((Object)("[Configuration Error] " + hostname + " /etc/hosts" + " entry is missing"));
            throw ex;
        }
        return ipAddress;
    }
}

