/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.HeartBeatListener;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.HeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.InitializationListener;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.InitializationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.ResourceInitializationEvent;
import com.tandbergtv.workflow.resourcemanager.util.StrategyClassLoadException;
import com.tandbergtv.workflow.resourcemanager.util.StrategyClassLoader;
import java.util.Map;
import org.apache.log4j.Logger;

class ResourceContainer {
    private Resource containedResource;
    private HeartBeatStrategy heartbeatStrategy;
    private InitializationStrategy initializationStrategy;
    private static Logger log = Logger.getLogger(ResourceContainer.class);

    ResourceContainer(Resource resource, ResourceManager manager) {
        this.containedResource = resource;
        this.initialize(manager);
    }

    private void initialize(ResourceManager manager) {
        String msg;
        ResourceType resType = this.containedResource.getResourceType();
        String systemId = resType.getSystemId();
        PluginManagement pluginManager = (PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class);
        ResourceTypeDescriptor desc = pluginManager.getResourceTypeDescriptor(systemId);
        String hbStrategyClass = null;
        Map<String, String> heartbeatProperties = null;
        String initStrategyClass = null;
        Map<String, String> initProperties = null;
        ClassLoader loader = null;
        if (desc != null) {
            hbStrategyClass = desc.getManagement().getHeartbeatStrategyClass();
            heartbeatProperties = desc.getManagement().getHeartbeatProperties();
            initStrategyClass = desc.getManagement().getInitializationStrategyClass();
            initProperties = desc.getManagement().getInitializationProperties();
            loader = desc.getClassLoader();
        }
        try {
            if (hbStrategyClass != null) {
                this.heartbeatStrategy = StrategyClassLoader.loadHeartBeatStrategy(hbStrategyClass, loader);
                this.heartbeatStrategy.setConfiguration(heartbeatProperties);
            } else {
                this.heartbeatStrategy = StrategyClassLoader.createDefaultHeartBeatStrategy();
            }
        }
        catch (StrategyClassLoadException scle) {
            msg = "Failed to load the HeartBeat Strategy, using the Default Strategy instead.";
            log.error((Object)msg, (Throwable)scle);
            this.heartbeatStrategy = StrategyClassLoader.createDefaultHeartBeatStrategy();
        }
        try {
            if (initStrategyClass != null) {
                this.initializationStrategy = StrategyClassLoader.loadInitializationStrategy(initStrategyClass, loader);
                this.initializationStrategy.setConfiguration(initProperties);
            } else {
                this.initializationStrategy = StrategyClassLoader.createDefaultInitializationStrategy();
            }
        }
        catch (StrategyClassLoadException scle) {
            msg = "Failed to load the Initialization Strategy, using the Default Strategy instead.";
            log.error((Object)msg, (Throwable)scle);
            this.initializationStrategy = StrategyClassLoader.createDefaultInitializationStrategy();
        }
        if (this.heartbeatStrategy != null) {
            this.heartbeatStrategy.setResource(manager.cloneResource(this.containedResource));
            this.heartbeatStrategy.addHeartBeatListener(new ResourceHeartBeatListener(manager));
        }
        if (this.initializationStrategy != null) {
            this.initializationStrategy.setResource(manager.cloneResource(this.containedResource));
            this.initializationStrategy.addInitializationListener(new ResourceInitializationListener(manager));
        }
    }

    Resource getResource() {
        return this.containedResource;
    }

    void setResource(Resource resource) {
        this.containedResource = resource;
        if (this.heartbeatStrategy != null) {
            this.heartbeatStrategy.setResource((Resource)this.containedResource.clone());
        }
        if (this.initializationStrategy != null) {
            this.initializationStrategy.setResource((Resource)this.containedResource.clone());
        }
    }

    HeartBeatStrategy getHeartBeatStrategy() {
        return this.heartbeatStrategy;
    }

    InitializationStrategy getInitializationStrategy() {
        return this.initializationStrategy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceContainer) {
            ResourceContainer resContObj = (ResourceContainer)obj;
            return this.getResource().equals(resContObj.getResource());
        }
        return false;
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    class ResourceInitializationListener
    implements InitializationListener {
        private ResourceManager manager;

        ResourceInitializationListener(ResourceManager manager) {
            this.manager = manager;
        }

        @Override
        public void initializationSuccess(ResourceInitializationEvent event) {
            log.info((Object)("Received Initialization Success Event for Resource[" + ResourceContainer.this.containedResource.getId() + "]: " + ResourceContainer.this.containedResource.getName()));
            this.manager.handleInitializationSuccess(event);
        }

        @Override
        public void initializationFailure(ResourceInitializationEvent event) {
            String msg = "[Resource] Received Initialization Failure Event for Resource[" + ResourceContainer.this.containedResource.getId() + "]: " + ResourceContainer.this.containedResource.getName();
            if (event.getMessage() != null) {
                msg = msg + ": " + event.getMessage();
            }
            if (event.getError() != null) {
                log.warn((Object)msg, event.getError());
            } else {
                log.warn((Object)msg);
            }
            Throwable t = event.getError() == null ? new Throwable() : event.getError();
            ResourceInitializationEvent clone = new ResourceInitializationEvent(event.getSource(), ResourceContainer.this.containedResource, msg, t);
            this.manager.handleInitializationFailure(clone);
        }
    }

    class ResourceHeartBeatListener
    implements HeartBeatListener {
        private ResourceManager manager;

        ResourceHeartBeatListener(ResourceManager manager) {
            this.manager = manager;
        }

        @Override
        public void heartbeatSuccess(ResourceHeartBeatEvent event) {
            log.debug((Object)("Received HeartBeat Success Event for Resource[" + ResourceContainer.this.containedResource.getId() + "]: " + ResourceContainer.this.containedResource.getName()));
            this.manager.handleHeartBeatSuccess(event);
        }

        @Override
        public void heartbeatFailure(ResourceHeartBeatEvent event) {
            String msg = "[Resource] Received HeartBeat Failure Event for Resource[" + ResourceContainer.this.containedResource.getId() + "]: " + ResourceContainer.this.containedResource.getName();
            if (event.getMessage() != null) {
                msg = msg + ": " + event.getMessage();
            }
            if (event.getError() != null) {
                log.warn((Object)msg, event.getError());
            } else {
                log.warn((Object)msg);
            }
            Throwable t = event.getError() == null ? new Throwable() : event.getError();
            ResourceHeartBeatEvent clone = new ResourceHeartBeatEvent(event.getSource(), ResourceContainer.this.containedResource, event.getMessage(), t);
            this.manager.handleHeartBeatFailure(clone);
        }
    }
}

