/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.auth.boot;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.workflow.auth.CredentialsManager;
import com.tandbergtv.workflow.auth.ICredentialsManager;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.io.File;
import java.util.ArrayList;

public class Activator {
    private static final String AUTH_FILE_NAME = "auth.xml";
    private static final String WORKFLOW_FOLDER_NAME = "workflow";
    private static final String CREDENTIALS_MANAGER_NAME = "WORKFLOW_CREDENTIALS_MANAGER";

    public void start() {
        IConfigurationService configReaderService = (IConfigurationService)ServiceRegistry.getDefault().lookup("Configuration Admin");
        ArrayList<File> authFiles = new ArrayList<File>();
        authFiles.add(configReaderService.getFile(WORKFLOW_FOLDER_NAME, AUTH_FILE_NAME));
        CredentialsManager credentialsManager = new CredentialsManager(authFiles, CREDENTIALS_MANAGER_NAME);
        ServiceRegistry.getDefault().register(credentialsManager.getServiceName(), (Service)credentialsManager);
        credentialsManager.start();
    }

    public void stop() {
        ICredentialsManager credentialsManager = (ICredentialsManager)ServiceRegistry.getDefault().lookup(CREDENTIALS_MANAGER_NAME);
        if (credentialsManager != null) {
            credentialsManager.stop();
            ServiceRegistry.getDefault().unregister((Service)credentialsManager);
        }
    }
}

