/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.conf;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.ResourceBundle;

public class Activator {
    private static final String SERVICE_NAME = "Configuration Admin";

    public void start() {
        Service service = this.instantiate();
        service.start();
        ServiceRegistry.getDefault().register(SERVICE_NAME, service);
    }

    public void stop() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup(SERVICE_NAME);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private Service instantiate() {
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".configuration");
        String className = bundle.getString("class");
        Service service = null;
        try {
            service = (Service)this.getClass().getClassLoader().loadClass(className).newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Configuration class not loaded: " + className, t);
        }
        return service;
    }
}

