/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.registry;

import com.tandbergtv.workflow.adaptor.IAdaptor;
import com.tandbergtv.workflow.adaptor.IAdaptorRequest;
import com.tandbergtv.workflow.adaptor.internal.AbstractDefaultAdaptor;
import com.tandbergtv.workflow.adaptor.registry.IAdaptorRegistry;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AdaptorRegistryImpl
implements IAdaptorRegistry {
    private HashMap<String, IAdaptor> registry = new HashMap();
    private AbstractDefaultAdaptor defaultAdaptor;
    private static final Logger logger = Logger.getLogger(AdaptorRegistryImpl.class);

    @Override
    public IAdaptor getAdaptor(String className) {
        return this.registry.get(className);
    }

    @Override
    public IAdaptor getAdaptor(IAdaptorRequest request) {
        for (IAdaptor adaptor : this.getRegisteredAdaptors()) {
            try {
                if (!adaptor.canDeliver(request)) continue;
                return adaptor;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        logger.debug((Object)"Returning default adaptor");
        return this.getDefaultAdaptor();
    }

    @Override
    public synchronized void registerAdaptor(String className, IAdaptor adaptor) {
        this.registry.put(className, adaptor);
    }

    @Override
    public Iterable<IAdaptor> getRegisteredAdaptors() {
        return this.registry.values();
    }

    @Override
    public AbstractDefaultAdaptor getDefaultAdaptor() {
        return this.defaultAdaptor;
    }

    @Override
    public void setDefaultAdaptor(AbstractDefaultAdaptor adaptor) {
        this.defaultAdaptor = adaptor;
    }

    public String getServiceName() {
        return "Adaptor Registry";
    }

    public void start() {
    }

    public void stop() {
        for (IAdaptor adaptor : this.registry.values()) {
            adaptor.destroy();
            Object var2_2 = null;
        }
        this.registry.clear();
        this.defaultAdaptor = null;
    }
}

