/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.message;

import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.comm.routing.RoutingServiceFactory;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.exe.AbstractAction;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageFactory;
import com.tandbergtv.workflow.message.command.ICommandExecutor;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.util.DeviceTypeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.taskmgmt.def.Task;

public abstract class AbstractMessageEmitter
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private String send;
    private Map<?, ?> map;
    private static final Logger logger = Logger.getLogger(AbstractMessageEmitter.class);

    protected AbstractMessageEmitter() {
    }

    protected void start(ExecutionContext context) {
        WorkflowMessage request = this.createRequest(context);
        WorkflowMessage response = this.send(request, context);
        this.validate(response);
        this.copy(response, context);
        ICommandExecutor executor = (ICommandExecutor)ServiceRegistry.getDefault().lookup(ICommandExecutor.class);
        executor.execute(response);
    }

    protected WorkflowMessage send(WorkflowMessage request, ExecutionContext context) {
        Resource resource = this.getResource(context);
        Token token = context.getToken();
        this.saveRequest(request, token, resource);
        final IDestination destination = (IDestination)DeviceTypeUtil.createDevice((Resource)resource);
        logger.info((Object)("[Process] " + token + " calling resource " + resource + " (" + destination + ")"));
        WorkflowMessage response = null;
        try {
            IRoutingService service = RoutingServiceFactory.newInstance().createRoutingService();
            response = service.send(request, (List)new ArrayList<IDestination>(){
                {
                    this.add(destination);
                }
            });
            response.setKey(request.getKey());
        }
        catch (CommunicationException e) {
            throw new ActionException((Throwable)e);
        }
        this.saveResponse(response, token, resource);
        return response;
    }

    protected WorkflowMessage createRequest(ExecutionContext context) {
        WorkflowMessage message = null;
        message = WorkflowMessageFactory.createControlMessage((String)this.send, (ExecutionContext)context);
        Map<String, Object> parameters = this.getProcessParameters(context);
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            logger.debug((Object)("Global variable " + key + " value " + value));
            if (value == null) continue;
            message.putValue(key, value);
        }
        if (this.map != null) {
            for (String key : this.map.keySet()) {
                message.putValue(key.toString(), this.map.get(key).toString());
                logger.debug((Object)("Local variable " + key + " value " + this.map.get(key)));
            }
        }
        return message;
    }

    protected void validate(WorkflowMessage response) {
        if (response.getType() == WorkflowMessage.MessageType.nack) {
            throw new ActionException((String)response.getParameterValue("error-message"));
        }
    }

    protected Resource getResource(ExecutionContext context) {
        ContextInstance c = context.getProcessInstance().getContextInstance();
        Resource resource = (Resource)c.getTransientVariable("_resource_" + context.getToken().getId());
        if (resource == null) {
            throw new ActionException(context.getToken() + ", resource unavailable");
        }
        return resource;
    }

    protected void saveRequest(WorkflowMessage request, Token token, Resource resource) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent(token, token.getNode(), false, resource, request));
    }

    protected void saveResponse(WorkflowMessage response, Token token, Resource resource) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowMessageLogEvent(token, token.getNode(), true, resource, response));
    }

    protected Map<String, Object> getProcessParameters(ExecutionContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Collection<TaskVariable> variables = this.getVariables(context);
        for (TaskVariable variable : variables) {
            if (!variable.isReadable()) continue;
            String name = variable.getVariableName();
            Object value = context.getVariable(name);
            if (variable.getMappedName() != null) {
                name = variable.getMappedName();
            }
            map.put(name, value);
        }
        return map;
    }

    protected Collection<TaskVariable> getVariables(ExecutionContext context) {
        ArrayList<TaskVariable> variables = new ArrayList<TaskVariable>();
        TaskNode node = (TaskNode)context.getToken().getNode();
        Set tasks = node.getTasks();
        if (tasks != null && !tasks.isEmpty()) {
            return ((Task)tasks.iterator().next()).getTaskController().getVariableAccesses();
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(WorkflowMessage response, ExecutionContext context) {
        Collection<TaskVariable> variables = this.getVariables(context);
        WorkflowProcess process = (WorkflowProcess)context.getToken().getProcessInstance();
        process.lock();
        try {
            for (TaskVariable variable : variables) {
                if (!variable.isWritable()) continue;
                String name = variable.getVariableName();
                Object value = response.getParameterValue(variable.getMappedName());
                if (value == null && response.getCommand() != null) {
                    value = response.getCommand().getParameterValue(variable.getMappedName());
                }
                logger.debug((Object)("Writing variable " + name + " value " + value));
                context.setVariable(name, value);
            }
        }
        finally {
            process.unlock();
        }
    }
}

