/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.boot;

import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.licensing.LicenseKeyConstants;
import com.tandbergtv.workflow.core.licensing.LicenseManager;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.internal.CompositeCache;
import com.tandbergtv.workflow.core.service.internal.DistributedQueueService;
import com.tandbergtv.workflow.core.service.internal.DistributedScheduler;
import com.tandbergtv.workflow.core.service.internal.RecoverableDistributedScheduler;
import com.tandbergtv.workflow.core.service.queue.IDistributedQueueService;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.EngineDriver;
import com.tandbergtv.workflow.driver.boot.EngineDriverProperties;
import com.tandbergtv.workflow.driver.command.buffer.DelayedCommandService;
import com.tandbergtv.workflow.driver.command.buffer.IDelayedCommandService;
import com.tandbergtv.workflow.driver.internal.DefaultProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.internal.HibernatePersistenceService;
import com.tandbergtv.workflow.driver.internal.MessageQueueService;
import com.tandbergtv.workflow.driver.internal.ProcessManager;
import com.tandbergtv.workflow.driver.internal.TaskCompletionService;
import com.tandbergtv.workflow.driver.internal.callable.ReadClusterProperties;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.search.SearchService;
import com.tandbergtv.workflow.driver.search.TokenSearchService;
import com.tandbergtv.workflow.driver.service.IMessageQueueService;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.service.ITaskCompletionService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.driver.template.TemplateLoaderService;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import com.tandbergtv.workflow.driver.timer.TimerManager;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class Activator {
    private static final String PROCESS_MONITOR_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=Cumulative";
    private static final String PROCESS_MONITOR_CURRENT_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=Current";
    private static final String PROCESS_MONITOR_TOKENS_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=CurrentBranched";
    private static final Logger logger = Logger.getLogger(Activator.class);

    public void start() {
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".driver");
        EngineDriver driver = EngineDriver.getInstance();
        DefaultMediator.getInstance().register((IColleague)driver);
        int size = Integer.parseInt(bundle.getString("driver.cache.size"));
        CompositeCache cache = new CompositeCache(bundle.getString("driver.cache.name"), size);
        this.addService((Service)cache);
        SessionFactory factory = HibernateUtil.getSessionFactory();
        this.addService((Service)new SearchService(factory));
        Properties properties = new Properties();
        properties.setProperty("template.max.count", Integer.toString(this.getMaxTemplateCount()));
        this.addService((Service)new TemplateLoaderService(properties, factory));
        this.addService((Service)new TokenSearchService(factory));
        this.addService((Service)new HibernatePersistenceService(factory));
        this.addService((Service)new RecoverableDistributedScheduler("distributed-scheduler", 4));
        this.addService((Service)new DistributedScheduler("one-shot-distributed-scheduler", 8));
        this.addService((Service)new TaskCompletionService());
        this.addService((Service)new TimerManager());
        this.addService(new DelayedCommandService());
        this.addService((Service)new DistributedQueueService("distributed-queue"));
        this.addService((Service)new MessageQueueService());
        this.addService((Service)new DefaultProgressTrackingStrategy());
        ProcessManager service = new ProcessManager(this.getProperties());
        this.registerMBeans((IProcessManagerService)service);
        ServiceRegistry.getDefault().register(service.getServiceName(), (Service)service);
        service.start();
        if (Cluster.isMaster()) {
            service.recover();
        }
    }

    public void stop() {
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".driver");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_MBEAN_NAME));
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_CURRENT_MBEAN_NAME));
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_TOKENS_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"ProcessMonitor MBean unregistration failed");
        }
        EngineDriver driver = EngineDriver.getInstance();
        DefaultMediator.getInstance().unregister((IColleague)driver);
        this.removeService(IProcessManagerService.class);
        this.removeService(IProgressTrackingStrategy.class);
        this.removeService(ITimerService.class);
        this.removeService(IMessageQueueService.class);
        this.removeService(IDistributedQueueService.class);
        this.removeService(IDelayedCommandService.class);
        this.removeService(ITaskCompletionService.class);
        this.removeService("one-shot-distributed-scheduler");
        this.removeService("distributed-scheduler");
        this.removeService(ITemplateLoaderService.class);
        this.removeService(IPersistenceService.class);
        this.removeService(ITokenSearchService.class);
        this.removeService(IProcessSearchService.class);
        this.removeService(bundle.getString("driver.cache.name"));
        logger.info((Object)"Process execution runtime destroyed");
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void removeService(String name) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup(name);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private int getMaxTemplateCount() {
        int count = Integer.MAX_VALUE;
        try {
            String entry = LicenseManager.getInstance().getObject(LicenseKeyConstants.TEMPLATES);
            if (entry != null && entry.trim().length() > 0) {
                count = Integer.parseInt(entry.trim());
            }
        }
        catch (Exception e) {
            count = 0;
        }
        return count;
    }

    private void registerMBeans(IProcessManagerService service) {
        IStatistics statistics = service.getStatistics();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(statistics.getCumulativeStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_MBEAN_NAME));
            mbean = new StandardMBean(statistics.getProcessStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_CURRENT_MBEAN_NAME));
            mbean = new StandardMBean(statistics.getTokenStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_TOKENS_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"Registration of MBean failed, monitoring will not be available", (Throwable)e);
        }
    }

    private Properties getProperties() {
        EngineDriverProperties props = new EngineDriverProperties();
        if (Cluster.isMaster()) {
            return props;
        }
        ISchedulerService scheduler = (ISchedulerService)ServiceRegistry.getDefault().lookup("one-shot-distributed-scheduler");
        Future future = scheduler.schedule((Callable)new ReadClusterProperties());
        Properties properties = new Properties();
        try {
            properties = (Properties)future.get(30L, TimeUnit.SECONDS);
            for (Object name : properties.keySet()) {
                props.put(name, properties.get(name));
                logger.debug((Object)(name + "=" + properties.get(name)));
            }
            props.store();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get properties from master", (Throwable)e);
        }
        return props;
    }
}

