/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import com.tandbergtv.workflow.driver.template.watch.AbstractFileListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.jbpm.graph.def.ProcessDefinition;

public class PackagedTemplateFileListener
extends AbstractFileListener {
    @Override
    protected WorkflowTemplate read(File file) {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream((ZipInputStream)zipInputStream);
            WorkflowTemplate workflowTemplate = (WorkflowTemplate)processDefinition;
            return workflowTemplate;
        }
        catch (FileNotFoundException e) {
            throw new TemplateReaderException("Failed to read template " + file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException e) {
                    throw new TemplateReaderException("Failed to read template " + file.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }
}

