/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.message;

import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.IMessageQueueService;
import com.tandbergtv.workflow.exe.AbstractAction;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.taskmgmt.def.Task;

public abstract class AbstractMessageReceiver
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected String receive;
    private static final Logger logger = Logger.getLogger(AbstractMessageReceiver.class);

    protected AbstractMessageReceiver() {
    }

    protected void start(ExecutionContext context) {
        WorkflowMessage response = this.receive(context);
        this.validate(response);
        this.copy(response, context);
    }

    protected WorkflowMessage receive(ExecutionContext context) {
        WorkflowMessage message = null;
        Token token = context.getToken();
        IMessageQueueService service = (IMessageQueueService)ServiceRegistry.getDefault().lookup(IMessageQueueService.class);
        BlockingQueue queue = service.getQueue(token);
        if (queue == null) {
            throw new ActionException(token + ", message queue unavailable");
        }
        try {
            message = (WorkflowMessage)queue.take();
            logger.info((Object)(token + " received async response: " + message.getMessageUID()));
        }
        catch (Exception e) {
            throw new ActionException(token + ", error reading from message queue");
        }
        return message;
    }

    protected void validate(WorkflowMessage response) {
        if (response.getType() == WorkflowMessage.MessageType.nack) {
            throw new ActionException((String)response.getParameterValue("error-message"));
        }
    }

    protected Collection<TaskVariable> getVariables(ExecutionContext context) {
        ArrayList<TaskVariable> variables = new ArrayList<TaskVariable>();
        TaskNode node = (TaskNode)context.getToken().getNode();
        Set tasks = node.getTasks();
        if (tasks != null && !tasks.isEmpty()) {
            return ((Task)tasks.iterator().next()).getTaskController().getVariableAccesses();
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(WorkflowMessage response, ExecutionContext context) {
        Collection<TaskVariable> variables = this.getVariables(context);
        WorkflowProcess process = (WorkflowProcess)context.getToken().getProcessInstance();
        process.lock();
        try {
            for (TaskVariable variable : variables) {
                if (!variable.isWritable()) continue;
                String name = variable.getVariableName();
                Object value = response.getParameterValue(variable.getMappedName());
                if (value == null) {
                    value = response.getCommand().getParameterValue(variable.getMappedName());
                }
                logger.debug((Object)("Writing variable " + name + " value " + value));
                context.setVariable(name, value);
            }
        }
        finally {
            process.unlock();
        }
    }
}

