/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.watchpoint.watchfolder.core.IProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbstractFileListener
implements IProcess {
    private static final Logger logger = Logger.getLogger(AbstractFileListener.class);
    private static final String REJECTED = "rejected";
    private static final String IMPORTED = "imported";

    protected AbstractFileListener() {
    }

    public void fileCreated(FileInfo fileInfo) {
        block2: {
            ITemplateLoaderService service = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
            String path = fileInfo.getAbsolutePath();
            File file = new File(path);
            this.preCreate(file);
            try {
                WorkflowTemplate template = this.read(file);
                logger.debug((Object)("Loaded template " + template));
                service.save(template);
                this.postCreate(file);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to ingest template " + path), (Throwable)e);
                String dir = file.getParentFile().getParentFile() + File.separator + REJECTED;
                if (this.move(dir, file)) break block2;
                logger.warn((Object)("Failed to move file " + path + " to the rejected folder"));
            }
        }
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.warn((Object)"Ignoring file deleted event");
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.warn((Object)"Ignoring file updated event");
    }

    protected void preCreate(File file) {
        logger.debug((Object)("New file " + file.getAbsolutePath()));
    }

    protected void postCreate(File file) {
        String dir = file.getParentFile().getParentFile() + File.separator + IMPORTED;
        if (!this.move(dir, file)) {
            logger.warn((Object)("Failed to move file " + file.getAbsolutePath() + " to the imported folder"));
        }
    }

    private boolean move(String dir, File file) {
        String time = new SimpleDateFormat("yyyy-MM-dd-HHmmSS").format(new Date());
        return file.renameTo(new File(dir + File.separator + file.getName().replace(".", "-") + "-" + time + ".xml"));
    }

    protected abstract WorkflowTemplate read(File var1);
}

