/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.resource;

import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.resourcemanager.event.ReleaseResourceEvent;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class ReleaseResource
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(ReleaseResource.class);
    private static final long serialVersionUID = 2457819245589204128L;

    public void execute(ExecutionContext ec) throws Exception {
        Token token = ec.getToken();
        ContextInstance c = token.getProcessInstance().getContextInstance();
        Node node = ec.getTransitionSource();
        if (node == null) {
            node = token.getNode();
        }
        this.clearResourceAllocationKey(ec);
        String name = "_resource_" + token.getId();
        if (c.hasTransientVariable(name)) {
            logger.info((Object)(token + " node (" + node.getName() + ") releasing resource"));
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ReleaseResourceEvent(this, token, node));
            c.deleteTransientVariable(name);
        }
    }

    private void clearResourceAllocationKey(ExecutionContext ec) {
        String defaultVariableName = "_resource_host";
        String variableName = defaultVariableName + "_" + ec.getToken().getId();
        ec.setVariable(variableName, null);
        ec.setVariable(defaultVariableName, null);
    }
}

