/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.queue;

import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.queue.AbstractQueue;
import com.tandbergtv.workflow.core.queue.QueueException;
import com.tandbergtv.workflow.core.queue.QueueItem;
import com.tandbergtv.workflow.core.queue.monitor.IQueueMonitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.MarshalException;
import com.tandbergtv.workflow.message.util.Unmarshaller;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

final class MessageOffloadQueue<T>
extends AbstractQueue<WorkflowMessage>
implements Service,
IQueueMonitor,
IColleague {
    private ISchedulerService<Void> scheduler;
    private String dir;
    private ConcurrentLinkedQueue<String> filenames;
    private int total;
    private int max;
    private long totalDelay;
    private static final String NAME = "com.tandbergtv.workflow.mq";
    private static final Logger logger = Logger.getLogger(MessageOffloadQueue.class);

    public MessageOffloadQueue(String dir) {
        this.dir = dir;
        new File(this.getQueueDir()).mkdir();
        this.filenames = new ConcurrentLinkedQueue();
        this.scheduler = new Scheduler("mq", 1, 1);
    }

    String getQueueDir() {
        return this.dir + File.separator + "mq";
    }

    String getRejectedMessageDir() {
        return this.dir + File.separator + "rejected";
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    public long getAverageDelay() {
        if (this.total > 0) {
            return this.totalDelay / (long)this.total;
        }
        return 0L;
    }

    public int getMaxSize() {
        return this.max;
    }

    public int getSize() {
        return this.filenames.size();
    }

    public int getTotal() {
        return this.total;
    }

    protected Collection<QueueItem<WorkflowMessage>> getItems() {
        throw new UnsupportedOperationException("Cannot get all queue items");
    }

    public void insert(QueueItem<WorkflowMessage> item) {
        super.insert(item);
        ++this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueItem<WorkflowMessage> remove() {
        logger.debug((Object)"Removing...");
        if (this.filenames.isEmpty()) {
            throw new QueueException("Queue is empty");
        }
        QueueItem item = null;
        File file = new File(this.filenames.peek());
        try {
            item = this.removalstrategy.remove();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to remove item", (Throwable)e);
            file.renameTo(new File(this.getRejectedMessageDir() + File.separator + file.getName()));
        }
        finally {
            if (item != null) {
                this.totalDelay += item.getDelay();
            }
            this.filenames.remove();
            if (!file.delete()) {
                logger.warn((Object)("Failed to delete file: " + file + ", file may possibly be processed again."));
            }
        }
        return item;
    }

    public String getServiceName() {
        return NAME;
    }

    public void start() {
        logger.debug((Object)"Starting");
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        this.scheduler.start();
        this.scheduler.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (true) {
                    double threshold;
                    double rate;
                    if ((rate = MessageOffloadQueue.this.getCurrentRate()) < (threshold = MessageOffloadQueue.this.getMaxRate())) {
                        logger.debug((Object)("Average rate " + rate));
                        if (MessageOffloadQueue.this.filenames.isEmpty()) {
                            MessageOffloadQueue.this.fillQueue();
                        }
                        if (!MessageOffloadQueue.this.filenames.isEmpty()) {
                            MessageOffloadQueue.this.remove();
                        }
                    } else {
                        Thread.sleep(1000L);
                    }
                    if (!MessageOffloadQueue.this.filenames.isEmpty()) continue;
                    Thread.sleep(1000L);
                    logger.debug((Object)"Woke up");
                }
            }
        });
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
    }

    public void stop() {
        this.filenames.clear();
        this.scheduler.stop();
        logger.debug((Object)"Stopped");
    }

    public String getColleagueName() {
        return NAME;
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public void receive(WorkflowEvent event) {
        ServiceEvent se;
        String servicename;
        if (event instanceof ServiceEvent && (servicename = (se = (ServiceEvent)event).getService().getServiceName()) == "Process Manager" && se.getEvent() == ServiceEvents.STARTED) {
            this.start();
        }
    }

    void addDelay(long delay) {
        this.totalDelay += delay;
    }

    QueueItem<WorkflowMessage> getFirst() {
        String name = this.filenames.peek();
        if (name == null) {
            return null;
        }
        return this.getQueueItem(name);
    }

    private double getCurrentRate() {
        double rate = 0.0;
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("com.tandbergtv.watchpoint:type=ProcessMonitor");
            rate = (Double)server.getAttribute(name, "CreateRate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rate;
    }

    private double getMaxRate() {
        double rate = Double.MAX_VALUE;
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("com.tandbergtv.watchpoint:type=ProcessMonitor");
            rate = (Double)server.getAttribute(name, "MaxCreateRate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rate;
    }

    private QueueItem<WorkflowMessage> getQueueItem(String name) {
        File file = new File(name);
        QueueItem item = null;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            TransformerFactory.newInstance().newTransformer().transform(new StreamSource(file), new DOMResult(document));
            WorkflowMessage message = Unmarshaller.unmarshal((Document)document);
            item = new QueueItem((Object)message);
            int index = file.getName().indexOf("-");
            String prefix = file.getName().substring(0, index);
            item.setEnter(new Date(Long.parseLong(prefix)));
        }
        catch (ParserConfigurationException e) {
            throw new Error("Something is terribly broken", e);
        }
        catch (MarshalException e) {
            throw new QueueException("Failed to parse message", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new QueueException("Failed to parse message", (Throwable)e);
        }
        catch (NumberFormatException e) {
            item.setEnter(new Date());
        }
        return item;
    }

    private void fillQueue() {
        File directory = new File(this.getQueueDir());
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return name.endsWith("xml");
            }
        });
        if (files == null || files.length == 0) {
            return;
        }
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 0; i < files.length; ++i) {
            names.add(files[i].getAbsolutePath());
        }
        this.filenames.addAll(names);
        int size = files.length;
        if (size > this.max) {
            this.max = size;
        }
        logger.debug((Object)("Number of files " + size));
    }
}

