/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.message.queue;

import com.tandbergtv.workflow.core.queue.Queue;
import com.tandbergtv.workflow.core.queue.admit.AlwaysAdmit;
import com.tandbergtv.workflow.core.queue.admit.IAdmissionControl;
import com.tandbergtv.workflow.core.queue.provider.IQueueProvider;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.queue.InsertStrategy;
import com.tandbergtv.workflow.message.queue.MessageOffloadQueue;
import com.tandbergtv.workflow.message.queue.RemovalStrategy;

public class OffloadQueueProvider<T>
implements IQueueProvider<WorkflowMessage> {
    private String dir;

    public OffloadQueueProvider(String dir) {
        this.dir = dir;
    }

    public Queue<WorkflowMessage> createQueue() {
        if (this.dir == null) {
            throw new RuntimeException("Message queue directory not configured");
        }
        MessageOffloadQueue<WorkflowMessage> queue = new MessageOffloadQueue<WorkflowMessage>(this.dir);
        queue.setAdmissionControlStrategy((IAdmissionControl)new AlwaysAdmit(queue));
        queue.setInsertStrategy(new InsertStrategy(queue));
        queue.setRemovalStrategy(new RemovalStrategy(queue));
        return queue;
    }
}

