/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.log.WorkflowLogManager;
import com.tandbergtv.workflow.log.hibernate.HibernateDAOFactory;
import com.tandbergtv.workflow.monitor.AlertSystemHealthManager;
import com.tandbergtv.workflow.monitor.ISystemMonitor;
import com.tandbergtv.workflow.monitor.SystemMonitor;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class Activator {
    public static final String SYSTEM_MONITOR_MBEAN_NAME = "com.tandbergtv.watchpoint:type=System";
    private static final Logger logger = Logger.getLogger(Activator.class);

    public void start() {
        SessionFactory sessionFactory = HibernateUtil.getSessionFactory();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(new SystemMonitor(), ISystemMonitor.class);
            server.registerMBean(mbean, new ObjectName(SYSTEM_MONITOR_MBEAN_NAME));
            WorkflowLogManager log = new WorkflowLogManager(new HibernateDAOFactory(sessionFactory));
            ServiceRegistry.getDefault().register(log.getServiceName(), (Service)log);
            log.start();
            AlertSystemHealthManager.getInstance().initialize();
        }
        catch (InstanceAlreadyExistsException e) {
            throw new RuntimeException("System monitor MBean registration failed", e);
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException("System monitor MBean registration failed", e);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("System monitor MBean registration failed", e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("System monitor MBean registration failed", e);
        }
    }

    public void stop() {
        AlertSystemHealthManager.getInstance().shutdown();
        WorkflowLogManager log = (WorkflowLogManager)ServiceRegistry.getDefault().lookup(WorkflowLogManager.class);
        if (log != null) {
            log.stop();
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(SYSTEM_MONITOR_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"System monitor MBean unregistration failed");
        }
    }
}

