/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.health.ComponentHealthStatus;
import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.event.NodeTimeoutEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.event.message.TaskStatusEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.resourcemanager.ActionException;
import com.tandbergtv.workflow.resourcemanager.DataOperationException;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IAllocationKeyService;
import com.tandbergtv.workflow.resourcemanager.ResourceContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManagerContext;
import com.tandbergtv.workflow.resourcemanager.ValidationException;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import com.tandbergtv.workflow.resourcemanager.event.AcquireResourceEvent;
import com.tandbergtv.workflow.resourcemanager.event.ReleaseResourceEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceFailedEvent;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

public class ResourceManager
implements ResourceManagement,
IColleague {
    private static Logger logger = Logger.getLogger(ResourceManager.class);
    private static final String COLLEAGUE_NAME = "ResourceManager";
    private ResourceManagerContext context;
    private ISchedulerService<Void> eventHandlerPool = new Scheduler("resource-events", 1, 1);

    private ResourceManager() {
    }

    public ResourceManager(ResourceManagerContext context) {
        this();
        this.context = context;
        this.context.manager = this;
    }

    public String getServiceName() {
        return COLLEAGUE_NAME;
    }

    public void start() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            throw new RuntimeException("Resource manager failed to start", e);
        }
    }

    public void stop() {
        this.shutdown();
    }

    @Override
    public synchronized List<ResourceType> getAllResourceTypes() {
        ArrayList<ResourceType> resourceTypeList = new ArrayList<ResourceType>();
        for (ResourceType resType : this.context.resourceTypes.values()) {
            ResourceType clone = (ResourceType)resType.clone();
            resourceTypeList.add(clone);
        }
        return resourceTypeList;
    }

    @Override
    public synchronized ResourceType getResourceType(long resourceTypeId) throws FinderException {
        ResourceType result = null;
        ResourceType resourceType = null;
        resourceType = this.context.resourceTypes.containsKey(resourceTypeId) ? this.context.resourceTypes.get(resourceTypeId) : this.context.inactiveResourceTypes.get(resourceTypeId);
        if (resourceType == null) {
            String msg = "Could not find Resource Type with Id: " + resourceTypeId;
            throw new FinderException(msg);
        }
        result = (ResourceType)resourceType.clone();
        return result;
    }

    @Override
    public synchronized List<ResourceGroup> getAllResourceGroups() {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        for (ResourceGroupContainer rgContainer : this.context.resourceGroups.values()) {
            ResourceGroup clone = this.cloneResourceGroup(rgContainer.getResourceGroup());
            resourceGroupList.add(clone);
        }
        return resourceGroupList;
    }

    @Override
    public synchronized ResourceGroup getResourceGroup(long resourceGroupId) throws FinderException {
        ResourceGroup result = null;
        ResourceGroupContainer rgContainer = this.context.resourceGroups.get(resourceGroupId);
        if (rgContainer == null) {
            String msg = "Could not find Resource Group with Id: " + resourceGroupId;
            throw new FinderException(msg);
        }
        result = this.cloneResourceGroup(rgContainer.getResourceGroup());
        return result;
    }

    @Override
    public synchronized List<ResourceGroup> getResourceGroupsByResourceType(long resourceTypeId) {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        for (ResourceGroupContainer rgContainer : this.context.resourceGroups.values()) {
            if (rgContainer.getResourceGroup().getResourceType().getId() != resourceTypeId) continue;
            ResourceGroup clone = this.cloneResourceGroup(rgContainer.getResourceGroup());
            resourceGroupList.add(clone);
        }
        return resourceGroupList;
    }

    @Override
    public synchronized List<ResourceGroup> getResourceGroupsByResource(long resourceId) {
        ArrayList<ResourceGroup> resourceGroupList = new ArrayList<ResourceGroup>();
        ResourceContainer container = this.context.resources.get(resourceId);
        if (container == null) {
            return resourceGroupList;
        }
        Resource resource = container.getResource();
        for (ResourceGroup group : resource.getResourceGroups()) {
            ResourceGroupContainer rgContainer = this.context.resourceGroups.get(group.getId());
            ResourceGroup clone = this.cloneResourceGroup(rgContainer.getResourceGroup());
            resourceGroupList.add(clone);
        }
        return resourceGroupList;
    }

    @Override
    public synchronized ResourceGroup getResourceGroupByToken(long tokenId) {
        ResourceGroup match = null;
        Long resourceGroupId = this.context.queuedTokenLookup.get(tokenId);
        if (resourceGroupId != null && this.context.resourceGroups.containsKey(resourceGroupId)) {
            match = this.context.resourceGroups.get(resourceGroupId).getResourceGroup();
        }
        return this.cloneResourceGroup(match);
    }

    @Override
    public synchronized List<Resource> getAllResources() {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (ResourceContainer resContainer : this.context.resources.values()) {
            Resource clone = this.cloneResource(resContainer.getResource());
            resourceList.add(clone);
        }
        return resourceList;
    }

    @Override
    public synchronized List<Resource> getResourcesBySearchCriteria(SearchCriteria searchCriteria) throws DataOperationException {
        List<Resource> resourceList = null;
        Session currentSession = this.context.getCurrentSession();
        ResourceDAI resDAI = this.context.daoFactory.getResourceDAO();
        try {
            currentSession.beginTransaction();
            resourceList = resDAI.findBySearchCriteria(searchCriteria);
            currentSession.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            this.context.rollbackTransaction(currentSession.getTransaction());
            throw new DataOperationException("Failed to get the list of Resources from the Database.", ex);
        }
        ArrayList<Resource> clonedList = new ArrayList<Resource>();
        for (Resource resource : resourceList) {
            if (this.context.resources.containsKey(resource.getId())) {
                ResourceContainer resContainer = this.context.resources.get(resource.getId());
                Resource cachedResource = resContainer.getResource();
                clonedList.add(this.cloneResource(cachedResource));
                continue;
            }
            clonedList.add(this.cloneResource(resource));
        }
        return clonedList;
    }

    @Override
    public synchronized int getActiveResourcesCount() {
        return this.context.resources.size();
    }

    @Override
    public synchronized Resource getResource(long resourceId) throws FinderException, DataOperationException {
        Resource result = null;
        if (this.context.resources.containsKey(resourceId)) {
            ResourceContainer container = this.context.resources.get(resourceId);
            result = this.cloneResource(container.getResource());
        } else {
            Session currentSession = this.context.getCurrentSession();
            ResourceDAI resDAI = this.context.daoFactory.getResourceDAO();
            try {
                currentSession.beginTransaction();
                Resource resource = (Resource)resDAI.findByKey(resourceId);
                result = this.cloneResource(resource);
                currentSession.getTransaction().commit();
            }
            catch (RuntimeException ex) {
                this.context.rollbackTransaction(currentSession.getTransaction());
                throw new DataOperationException("Failed to get the Resource[" + resourceId + "] from the Database.", ex);
            }
        }
        return result;
    }

    @Override
    public synchronized List<Resource> getResourcesByGroup(long resourceGroupId) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        ResourceGroupContainer rgContainer = this.context.resourceGroups.get(resourceGroupId);
        if (rgContainer == null) {
            return resourceList;
        }
        ResourceGroup group = rgContainer.getResourceGroup();
        for (Resource resource : group.getResources()) {
            ResourceContainer container = this.context.resources.get(resource.getId());
            Resource clone = this.cloneResource(container.getResource());
            resourceList.add(clone);
        }
        return resourceList;
    }

    @Override
    public synchronized List<Resource> getResourcesByResourceType(long resourceTypeId) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (ResourceContainer resContainer : this.context.resources.values()) {
            if (resContainer.getResource().getResourceType().getId() != resourceTypeId) continue;
            Resource clone = this.cloneResource(resContainer.getResource());
            resourceList.add(clone);
        }
        return resourceList;
    }

    @Override
    public synchronized List<Resource> getResourcesBySystemId(String systemId) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (ResourceContainer resContainer : this.context.resources.values()) {
            if (!resContainer.getResource().getResourceType().getSystemId().equals(systemId)) continue;
            Resource clone = this.cloneResource(resContainer.getResource());
            resourceList.add(clone);
        }
        return resourceList;
    }

    @Override
    public synchronized Resource getResourceByToken(long tokenId) {
        ResourceContainer container = this.context.findResourceByToken(tokenId);
        Resource resource = container != null ? container.getResource() : null;
        return this.cloneResource(resource);
    }

    @Override
    public synchronized Resource getResourceByUser(String user) {
        ResourceContainer match = null;
        for (ResourceContainer container : this.context.resources.values()) {
            Resource resource = container.getResource();
            if (resource.getUserName() == null || !resource.getUserName().equals(user)) continue;
            match = container;
            break;
        }
        Resource resource = match != null ? match.getResource() : null;
        return this.cloneResource(resource);
    }

    @Override
    public synchronized Resource getResourceByConnectionString(String connectionString) {
        ResourceContainer match = null;
        for (ResourceContainer container : this.context.resources.values()) {
            Resource resource = container.getResource();
            if (resource.getConnectionString() == null || !resource.getConnectionString().equals(connectionString)) continue;
            match = container;
            break;
        }
        Resource resource = match != null ? match.getResource() : null;
        return this.cloneResource(resource);
    }

    @Override
    public synchronized Resource getResourceByConnectionString(String connectionString, long resourceGroupId) {
        if (connectionString == null) {
            return null;
        }
        ResourceGroupContainer rgContainer = this.context.resourceGroups.get(resourceGroupId);
        if (rgContainer == null) {
            return null;
        }
        for (Resource resource : rgContainer.getResourceGroup().getResources()) {
            if (!connectionString.equals(resource.getConnectionString())) continue;
            return this.cloneResource(this.context.resources.get(resource.getId()).getResource());
        }
        return null;
    }

    @Override
    public synchronized Resource setResourceOnline(long resourceId) throws FinderException, DataOperationException, ValidationException {
        ResourceContainer container = this.context.resources.get(resourceId);
        if (container == null) {
            String msg = "Could not set Resource with id=" + resourceId + "Online, no such Resource exists.";
            throw new FinderException(msg);
        }
        if (ResourceState.ONLINE != container.getResource().getAdministrationState()) {
            Resource clone = (Resource)container.getResource().clone();
            clone.setAdministrationState(ResourceState.ONLINE);
            try {
                Resource updatedResource = this.updateResourceInTransaction(clone);
                container.setResource(updatedResource);
            }
            catch (RuntimeException ex) {
                throw new DataOperationException("Failed to update the Resource Administration Status to Online in the Database.", ex);
            }
            logger.info((Object)("Resource[" + resourceId + "]: " + container.getResource().getName() + " is scheduled to go Online."));
            this.context.stateManager.initializeResource(container);
            this.context.storeResource(resourceId);
        } else {
            logger.debug((Object)("Resource: [" + resourceId + "]: " + container.getResource().getName() + " is already set Online."));
        }
        return this.cloneResource(container.getResource());
    }

    @Override
    public synchronized Resource setResourceOffline(long resourceId) throws FinderException, DataOperationException {
        ResourceContainer container = this.context.resources.get(resourceId);
        if (container == null) {
            String msg = "Could not set Resource with id=" + resourceId + "Offline, no such Resource exists.";
            throw new FinderException(msg);
        }
        if (ResourceState.OFFLINE != container.getResource().getAdministrationState()) {
            Resource clone = (Resource)container.getResource().clone();
            clone.setAdministrationState(ResourceState.OFFLINE);
            try {
                Resource updatedResource = this.updateResourceInTransaction(clone);
                container.setResource(updatedResource);
            }
            catch (RuntimeException ex) {
                throw new DataOperationException("Failed to update Resource[" + resourceId + "] Administration Status to Offline in the Database.", ex);
            }
            logger.info((Object)("Resource[" + resourceId + "]: " + container.getResource().getName() + " is scheduled to go Offline."));
            this.context.stateManager.tryTakeResourceOffline(container);
            this.context.storeResource(resourceId);
        } else {
            logger.debug((Object)("Resource: [" + resourceId + "]: " + container.getResource().getName() + " is already set Offline."));
        }
        return this.cloneResource(container.getResource());
    }

    @Override
    public synchronized Resource createResource(Resource resource) throws ValidationException, DataOperationException, FinderException {
        this.context.validator.checkLicense(resource);
        this.context.validator.validateResourceProperties(resource);
        if (resource.getId() != -1L) {
            ValidationException ve = new ValidationException();
            ve.addErrorCode("VR-203");
            throw ve;
        }
        resource.setOperationalState(ResourceState.OFFLINE);
        resource.setActive(true);
        Session currentSession = this.context.getCurrentSession();
        ResourceDAI resDAI = this.context.daoFactory.getResourceDAO();
        Resource savedResource = null;
        try {
            currentSession.beginTransaction();
            savedResource = resDAI.create(resource);
            currentSession.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            this.context.rollbackTransaction(currentSession.getTransaction());
            throw new DataOperationException("Failed to create the Resource in the Database.", ex);
        }
        ResourceContainer container = new ResourceContainer(savedResource, this);
        this.context.resources.put(savedResource.getId(), container);
        String systemId = resource.getResourceType().getSystemId();
        if (systemId.equals("04")) {
            this.context.setNumOfActiveHumanResources(this.context.getNumOfActiveHumanResources() + 1);
        } else if (!systemId.equals("PM")) {
            this.context.setNumOfActiveSystemResources(this.context.getNumOfActiveSystemResources() + 1);
        }
        for (ResourceGroup group : resource.getResourceGroups()) {
            ResourceGroupContainer rgContainer = this.context.resourceGroups.get(group.getId());
            rgContainer.getResourceGroup().addResource(resource);
        }
        this.context.stateManager.initializeResource(container);
        this.context.storeResource(savedResource.getId());
        return this.cloneResource(container.getResource());
    }

    @Override
    public synchronized Resource updateResource(Resource resource) throws ValidationException, ActionException, FinderException, DataOperationException {
        ResourceGroupContainer rgContainer;
        this.context.validator.validateResourceForModification(resource.getId(), true);
        this.context.validator.validateResourceProperties(resource);
        ResourceContainer container = this.context.resources.get(resource.getId());
        Resource origResource = container.getResource();
        ArrayList<Long> addedGroups = new ArrayList<Long>();
        ArrayList<Long> removedGroups = new ArrayList<Long>();
        for (ResourceGroup group : resource.getResourceGroups()) {
            if (origResource.getResourceGroups().contains(group)) continue;
            addedGroups.add(group.getId());
        }
        for (ResourceGroup group : origResource.getResourceGroups()) {
            if (resource.getResourceGroups().contains(group)) continue;
            removedGroups.add(group.getId());
        }
        resource.setOperationalState(origResource.getOperationalState());
        resource.setUsers(new HashSet<ResourceUser>());
        resource.setActive(true);
        Resource savedResource = null;
        try {
            savedResource = this.updateResourceInTransaction(resource);
            container.setResource(savedResource);
        }
        catch (RuntimeException ex) {
            throw new DataOperationException("Failed to update the Resource in the Database.", ex);
        }
        for (Long groupId : addedGroups) {
            rgContainer = this.context.resourceGroups.get(groupId);
            rgContainer.getResourceGroup().addResource(savedResource);
        }
        for (Long groupId : removedGroups) {
            rgContainer = this.context.resourceGroups.get(groupId);
            rgContainer.getResourceGroup().removeResource(savedResource);
        }
        this.context.stateManager.initializeResource(container);
        this.context.storeResource(resource.getId());
        return this.cloneResource(container.getResource());
    }

    @Override
    public synchronized boolean deleteResource(long resourceId) throws ActionException, FinderException, DataOperationException {
        this.context.validator.validateResourceForModification(resourceId, false);
        ResourceContainer container = this.context.resources.get(resourceId);
        Resource resource = container.getResource();
        Resource clone = (Resource)resource.clone();
        clone.removeAllResourceGroups();
        clone.setActive(false);
        clone.setUserName(null);
        try {
            this.updateResourceInTransaction(clone);
        }
        catch (RuntimeException ex) {
            throw new DataOperationException("Failed to delete Resource[" + resourceId + "] from the Database.", ex);
        }
        for (ResourceGroup group : resource.getResourceGroups()) {
            ResourceGroupContainer rgContainer = this.context.resourceGroups.get(group.getId());
            rgContainer.getResourceGroup().removeResource(resource);
        }
        resource.removeAllResourceGroups();
        this.context.resources.remove(resourceId);
        if (resource.getOperationalState() != ResourceState.INVALID && resource.getOperationalState() != ResourceState.INACTIVE) {
            String systemId = resource.getResourceType().getSystemId();
            if (systemId.equals("04")) {
                int actHumRes = this.context.getNumOfActiveHumanResources() - 1;
                this.context.setNumOfActiveHumanResources(actHumRes);
            } else if (!systemId.equals("PM")) {
                int actSysRes = this.context.getNumOfActiveSystemResources() - 1;
                this.context.setNumOfActiveSystemResources(actSysRes);
            }
        }
        return true;
    }

    @Override
    public synchronized boolean isResourceAvailable(long resourceId) {
        return this.context.queueManager.isResourceAvailableForAllocation(resourceId);
    }

    @Override
    public synchronized ResourceGroup moveQueueItemToTop(long resourceGroupId, long queueItemId) throws ActionException, FinderException {
        ResourceGroupContainer container = this.findResourceGroupContainer(resourceGroupId);
        boolean result = this.context.queueManager.moveQueueItemToTop(resourceGroupId, queueItemId);
        this.handleQueueOperationResult(result);
        return this.cloneResourceGroup(container.getResourceGroup());
    }

    @Override
    public synchronized ResourceGroup moveQueueItemToBottom(long resourceGroupId, long queueItemId) throws ActionException, FinderException {
        ResourceGroupContainer container = this.findResourceGroupContainer(resourceGroupId);
        boolean result = this.context.queueManager.moveQueueItemToBottom(resourceGroupId, queueItemId);
        this.handleQueueOperationResult(result);
        return this.cloneResourceGroup(container.getResourceGroup());
    }

    @Override
    public synchronized ResourceGroup moveQueueItemUp(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException, FinderException {
        ResourceGroupContainer container = this.findResourceGroupContainer(resourceGroupId);
        boolean result = this.context.queueManager.moveQueueItemUp(resourceGroupId, queueItemId, neighborQueueItemId);
        this.handleQueueOperationResult(result);
        return this.cloneResourceGroup(container.getResourceGroup());
    }

    @Override
    public synchronized ResourceGroup moveQueueItemDown(long resourceGroupId, long queueItemId, long neighborQueueItemId) throws ActionException, FinderException {
        ResourceGroupContainer container = this.findResourceGroupContainer(resourceGroupId);
        boolean result = this.context.queueManager.moveQueueItemDown(resourceGroupId, queueItemId, neighborQueueItemId);
        this.handleQueueOperationResult(result);
        return this.cloneResourceGroup(container.getResourceGroup());
    }

    @Override
    public synchronized void setResourceGroupQueueUIVisibility(long resourceGroupID, boolean visible) throws FinderException, DataOperationException {
        logger.debug((Object)("Requested Resource Group Queue UI Visibility: " + visible));
        ResourceGroupContainer rgContainer = this.context.resourceGroups.get(resourceGroupID);
        if (rgContainer == null) {
            String message = "No Resource Group exists for ID: " + resourceGroupID;
            throw new FinderException(message);
        }
        if (rgContainer.getResourceGroup().isVisible() == visible) {
            return;
        }
        ResourceGroup clonedResourceGroup = (ResourceGroup)rgContainer.getResourceGroup().clone();
        clonedResourceGroup.setVisible(visible);
        ResourceGroup updatedResourceGroup = this.updateResourceGroup(clonedResourceGroup);
        rgContainer.setResourceGroup(updatedResourceGroup);
    }

    private ResourceGroup updateResourceGroup(ResourceGroup resourceGroup) throws DataOperationException {
        ResourceGroup updatedResourceGroup = null;
        Session currentSession = this.context.getCurrentSession();
        ResourceGroupDAI resGroupDAI = this.context.daoFactory.getResourceGroupDAO();
        try {
            currentSession.beginTransaction();
            updatedResourceGroup = resGroupDAI.update(resourceGroup);
            currentSession.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            this.context.rollbackTransaction(currentSession.getTransaction());
            throw new DataOperationException("Failed to update Resource Group [" + resourceGroup.getId() + "] in Database", ex);
        }
        return updatedResourceGroup;
    }

    private ResourceGroupContainer findResourceGroupContainer(long resourceGroupId) throws FinderException {
        ResourceGroupContainer container = this.context.resourceGroups.get(resourceGroupId);
        if (container == null) {
            String msg = "Could not move Queue Item for Resource Group with id=" + resourceGroupId + ", no such Resource Group exists.";
            throw new FinderException(msg);
        }
        return container;
    }

    private void handleQueueOperationResult(boolean result) throws ActionException {
        if (!result) {
            String message = "The workorder selected to move is not in the queue any longer.";
            throw new ActionException(message, "QE-100");
        }
    }

    @Override
    public IAllocationKeyService getAllocationKeyService() {
        return this.context.allocationKeyService;
    }

    synchronized void initialize() throws InvalidLicenseException {
        this.eventHandlerPool.start();
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        this.context.lifeCycleManager.initialize();
        this.context.mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
    }

    void shutdown() {
        if (this.context.mediator != null) {
            this.context.mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
            this.context.lifeCycleManager.shutdown();
            this.context.mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
        }
        this.eventHandlerPool.stop();
    }

    @Override
    public synchronized ComponentHealthStatus getHealthStatus() {
        ComponentHealthStatus status = ComponentHealthStatus.OK;
        for (ResourceContainer container : this.context.resources.values()) {
            Resource resource = container.getResource();
            if (!resource.getOperationalState().isError()) continue;
            status = ComponentHealthStatus.ERROR;
            break;
        }
        return status;
    }

    public String getColleagueName() {
        return COLLEAGUE_NAME;
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(final WorkflowEvent event) {
        this.eventHandlerPool.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    if (event instanceof AcquireResourceEvent) {
                        ResourceManager.this.handleAcquireResourceEvent((AcquireResourceEvent)event);
                    } else if (event instanceof ReleaseResourceEvent) {
                        ResourceManager.this.handleReleaseResourceEvent((ReleaseResourceEvent)event);
                    } else if (event instanceof WorkflowProcessEvent) {
                        WorkflowProcessEvent processEvent = (WorkflowProcessEvent)event;
                        WorkflowProcessEventType processEventType = processEvent.getType();
                        switch (processEventType) {
                            case PAUSED: {
                                ResourceManager.this.handlePauseWorkOrderEvent(processEvent);
                                break;
                            }
                            case CANCELLED: {
                                ResourceManager.this.handleCancelWorkOrderEvent(processEvent);
                                break;
                            }
                            case PRIORITY_CHANGED: {
                                ResourceManager.this.handlePriorityChangedEvent(processEvent);
                                break;
                            }
                            case FAILED: {
                                ResourceManager.this.handleTokenFailedEvent(processEvent);
                                break;
                            }
                            case TIMEOUT: {
                                ResourceManager.this.handleNodeTimeoutEvent((NodeTimeoutEvent)processEvent);
                                break;
                            }
                        }
                    } else if (event instanceof TaskStatusEvent) {
                        ResourceManager.this.handleTaskStatusEvent((TaskStatusEvent)event);
                    } else if (event instanceof ServiceEvent) {
                        ResourceManager.this.handleServiceEvent((ServiceEvent)event);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Error while handling event " + event.getClass().getSimpleName() + " in the Resource Manager."), (Throwable)e);
                }
                return null;
            }
        });
    }

    private synchronized void handleAcquireResourceEvent(AcquireResourceEvent event) {
        this.context.eventHandler.handleAcquireResourceEvent(event);
    }

    private synchronized void handleReleaseResourceEvent(ReleaseResourceEvent event) {
        this.context.eventHandler.handleReleaseResourceEvent(event);
    }

    private synchronized void handlePauseWorkOrderEvent(WorkflowProcessEvent event) {
        this.context.eventHandler.handlePauseWorkOrderEvent(event);
    }

    private synchronized void handleCancelWorkOrderEvent(WorkflowProcessEvent event) {
        this.context.eventHandler.handleCancelWorkOrderEvent(event);
    }

    private synchronized void handleTokenFailedEvent(WorkflowProcessEvent event) {
        this.context.eventHandler.handleTokenFailedEvent(event);
    }

    private synchronized void handlePriorityChangedEvent(WorkflowProcessEvent event) {
        this.context.eventHandler.handlePriorityChangedEvent(event);
    }

    private synchronized void handleNodeTimeoutEvent(NodeTimeoutEvent event) {
        this.context.eventHandler.handleNodeTimeoutEvent(event);
    }

    private synchronized void handleTaskStatusEvent(TaskStatusEvent event) {
        this.context.eventHandler.handleTaskStatusEvent(event);
    }

    private synchronized void handleServiceEvent(ServiceEvent event) {
        this.context.eventHandler.handleServiceEvent(event);
    }

    synchronized boolean tryToAllocate(long resourceGroupId) {
        return this.context.queueManager.tryToAllocate(resourceGroupId);
    }

    void handleInitializationSuccess(final long resourceId) {
        this.eventHandlerPool.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                ResourceManager.this.internallyHandleInitializationSuccess(resourceId);
                return null;
            }
        });
    }

    void handleInitializationFailure(final long resourceId) {
        this.eventHandlerPool.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                ResourceManager.this.internallyHandleInitializationFailure(resourceId);
                return null;
            }
        });
    }

    private synchronized void internallyHandleInitializationSuccess(long resourceId) {
        ResourceContainer container = this.context.resources.get(resourceId);
        if (container == null) {
            return;
        }
        this.context.stateManager.handleInitializationSuccess(container);
        this.context.storeResource(resourceId);
    }

    private synchronized void internallyHandleInitializationFailure(long resourceId) {
        ResourceContainer container = this.context.resources.get(resourceId);
        if (container == null) {
            return;
        }
        boolean stateChanged = this.context.stateManager.handleInitializationFailure(container);
        if (stateChanged) {
            this.context.storeResource(resourceId);
        }
    }

    void handleHeartBeatSuccess(final long resourceId) {
        this.eventHandlerPool.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                ResourceManager.this.internallyHandleHeartBeatSuccess(resourceId);
                return null;
            }
        });
    }

    void handleHeartBeatFailure(final long resourceId) {
        this.eventHandlerPool.schedule((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                ResourceManager.this.internallyHandleHeartBeatFailure(resourceId);
                return null;
            }
        });
    }

    private synchronized void internallyHandleHeartBeatSuccess(long resourceId) {
        ResourceContainer container = this.context.resources.get(resourceId);
        if (container == null) {
            return;
        }
        boolean stateChanged = this.context.stateManager.handleHeartBeatSuccess(container);
        if (stateChanged) {
            this.context.storeResource(resourceId);
        }
    }

    private synchronized void internallyHandleHeartBeatFailure(long resourceId) {
        ResourceContainer container = this.context.resources.get(resourceId);
        if (container == null) {
            return;
        }
        boolean stateChanged = this.context.stateManager.handleHeartBeatFailure(container);
        if (stateChanged) {
            this.context.storeResource(resourceId);
        }
        if (container.getResource().getUserCount() > 0) {
            Resource resource = container.getResource();
            Resource clone = this.cloneResource(resource);
            for (ResourceUser user : resource.getUsers()) {
                long tokenId = -1L;
                try {
                    tokenId = user.getId();
                    logger.debug((Object)("Token [" + tokenId + "] currently using Resource[" + resource.getId() + "]: " + resource.getName() + " is being notified about a received heartbeat failure."));
                    IPersistenceService service = (IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class);
                    CustomToken token = service.getToken((Serializable)Long.valueOf(tokenId));
                    Node node = token.getNode();
                    ResourceFailedEvent event = new ResourceFailedEvent(this, (Token)token, node, clone);
                    this.context.mediator.sendAsync((WorkflowEvent)event);
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to notify Token [" + tokenId + "] using Resource[" + resource.getId() + "]: " + resource.getName() + " about a received heartbeat failure."), (Throwable)ex);
                }
            }
        }
    }

    private Resource updateResourceInTransaction(Resource resource) {
        Resource updatedResource = null;
        Session currentSession = this.context.getCurrentSession();
        ResourceDAI resDAI = this.context.daoFactory.getResourceDAO();
        try {
            currentSession.beginTransaction();
            updatedResource = resDAI.update(resource);
            currentSession.getTransaction().commit();
        }
        catch (RuntimeException ex) {
            this.context.rollbackTransaction(currentSession.getTransaction());
            throw ex;
        }
        return updatedResource;
    }

    Resource cloneResource(Resource resource) {
        if (resource == null) {
            return null;
        }
        Resource clone = (Resource)resource.clone();
        HashSet<ResourceGroup> resourceGroupSet = new HashSet<ResourceGroup>();
        for (ResourceGroup group : clone.getResourceGroups()) {
            ResourceGroupContainer container = this.context.resourceGroups.get(group.getId());
            ResourceGroup childClone = (ResourceGroup)container.getResourceGroup().clone();
            childClone.setResources(new HashSet<Resource>());
            resourceGroupSet.add(childClone);
        }
        clone.setResourceGroups(resourceGroupSet);
        return clone;
    }

    ResourceGroup cloneResourceGroup(ResourceGroup group) {
        if (group == null) {
            return null;
        }
        ResourceGroup clone = (ResourceGroup)group.clone();
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        for (Resource resource : clone.getResources()) {
            ResourceContainer container = this.context.resources.get(resource.getId());
            Resource childClone = (Resource)container.getResource().clone();
            childClone.setResourceGroups(new HashSet<ResourceGroup>());
            resourceSet.add(childClone);
        }
        clone.setResources(resourceSet);
        return clone;
    }
}

