/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.hibernate;

import com.tandbergtv.workflow.log.AbstractDAOFactory;
import com.tandbergtv.workflow.log.IProcessQueuedPerResourceLogDAO;
import com.tandbergtv.workflow.log.IProcessStatusPerResourceLogDAO;
import com.tandbergtv.workflow.log.IWorkflowMessageLogDAO;
import com.tandbergtv.workflow.log.IWorkflowNodeLogDAO;
import com.tandbergtv.workflow.log.hibernate.ProcessQueuedPerResourceLogHDAO;
import com.tandbergtv.workflow.log.hibernate.ProcessStatusPerResourceLogHDAO;
import com.tandbergtv.workflow.log.hibernate.WorkflowMessageLogHDAO;
import com.tandbergtv.workflow.log.hibernate.WorkflowNodeLogHDAO;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateDAOFactory
extends AbstractDAOFactory {
    private SessionFactory sessionFactory;

    public HibernateDAOFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public IWorkflowNodeLogDAO getWorkflowNodeLogDAO() {
        return new WorkflowNodeLogHDAO((Session)this.sessionFactory.openSession());
    }

    @Override
    public IWorkflowMessageLogDAO getWorkflowMessageLogDAO() {
        return new WorkflowMessageLogHDAO((Session)this.sessionFactory.openSession());
    }

    @Override
    public IProcessQueuedPerResourceLogDAO getProcessQueuedPerResourceLogDAO() {
        return new ProcessQueuedPerResourceLogHDAO((Session)this.sessionFactory.openSession());
    }

    @Override
    public IProcessStatusPerResourceLogDAO getProcessStatusPerResourceLogDAO() {
        return new ProcessStatusPerResourceLogHDAO((Session)this.sessionFactory.openSession());
    }
}

