/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.event.TaskCreatedEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.event.message.MessageRejectedEvent;
import com.tandbergtv.workflow.driver.event.message.TaskCompleteEvent;
import com.tandbergtv.workflow.driver.event.message.TaskUpdateEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import com.tandbergtv.workflow.resourcemanager.event.QueueOrderChangedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAcquiredEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceAllocationFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceFailedEvent;
import com.tandbergtv.workflow.resourcemanager.event.ResourceRequestRejectedEvent;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.Token;

public final class EngineDriver
implements IColleague {
    private static EngineDriver instance;
    private static final Logger logger;
    private static final String ALLOCATED_RESOURCE_KEY_VARIABLE = "_allocated_resource_";

    private EngineDriver() {
    }

    public static synchronized EngineDriver getInstance() {
        if (instance == null) {
            instance = new EngineDriver();
        }
        return instance;
    }

    private IProcessManagerService getProcessManagerService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    private void save(WorkflowProcess process) {
        ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).save(process);
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        Object source = event.getSource();
        if (source == this) {
            return;
        }
        IProgressTrackingStrategy progressTracker = (IProgressTrackingStrategy)ServiceRegistry.getDefault().lookup(IProgressTrackingStrategy.class);
        if (event instanceof WorkflowProcessEvent) {
            WorkflowProcessEvent e = (WorkflowProcessEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            WorkflowProcess process = token.getProcessInstance();
            logger.debug((Object)(token + ", event " + e.getType()));
            switch (e.getType()) {
                case RESUMED: {
                    if (token.isRoot()) {
                        this.cache(process);
                    }
                    if (!token.isTrace()) break;
                    this.save(process);
                    break;
                }
                case STARTED: {
                    if (token.isRoot()) {
                        this.cache(process);
                    }
                    if (!token.isTrace()) break;
                    this.save(process);
                    break;
                }
                case DEQUEUED: 
                case ACQUIRED: 
                case RELEASED: {
                    if (!token.isTrace()) break;
                    this.save(process);
                    break;
                }
                case BRANCHED: 
                case JOINED: 
                case DELETED: {
                    this.save(process);
                    break;
                }
                case QUEUED: {
                    progressTracker.setComplete((Token)token);
                    if (!token.isTrace()) break;
                    this.save(process);
                    break;
                }
                case STOPPED: {
                    if (token.isTrace() || token.isRoot()) {
                        this.save(process);
                    }
                    if (!token.isRoot()) break;
                    this.remove(process);
                    break;
                }
                case PAUSING: 
                case CANCELLING: {
                    if (!token.isRoot() || !token.isTrace()) break;
                    this.save(process);
                    break;
                }
                case PAUSED: 
                case CANCELLED: {
                    this.getTimerService().deleteTimer((Token)token);
                    this.save(process);
                    if (!token.isRoot()) break;
                    this.remove(process);
                    break;
                }
                case FAILED: {
                    this.getTimerService().deleteTimer((Token)token);
                    this.save(process);
                    if (token.isRoot()) {
                        this.remove(process);
                    }
                    try {
                        if (token.isResumeAfterFail()) {
                            logger.debug((Object)(token + " indicates that it wants to be retried"));
                            token.setResumeAfterFail(false);
                            this.getProcessManagerService().resume(token);
                        }
                    }
                    catch (DriverException t) {
                        logger.warn((Object)(process + " failed to resume"), (Throwable)t);
                    }
                    break;
                }
                case CRASHED: {
                    if (token.isTrace()) {
                        this.save(process);
                    }
                    if (!token.isRoot()) break;
                    this.remove(process);
                }
            }
        } else if (event instanceof TaskUpdateEvent) {
            TaskUpdateEvent e = (TaskUpdateEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            if (token.getStatus() == ProcessStatus.BUSY || token.getStatus() == ProcessStatus.RUNNING) {
                String percent = e.getPercentComplete();
                String name = token.getNode().getName();
                logger.info((Object)(token + " (" + name + ") " + percent + "% complete"));
                progressTracker.setPercentComplete((Token)token, percent);
            }
        } else if (event instanceof TaskCreatedEvent) {
            TaskCreatedEvent e = (TaskCreatedEvent)event;
            WorkflowProcess process = e.getProcess();
            this.save(process);
        } else if (event instanceof TaskCompleteEvent) {
            TaskCompleteEvent e = (TaskCompleteEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            String name = token.getNode().getName();
            if (token.getStatus() == ProcessStatus.QUEUED && e.hasFailed()) {
                logger.info((Object)(token + " has failed at (" + name + ")"));
                token.fail();
            } else {
                logger.info((Object)(token + " (" + name + ") completed"));
            }
        } else if (event instanceof ResourceAcquiredEvent) {
            ResourceAcquiredEvent e = (ResourceAcquiredEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            if (token.getStatus() == ProcessStatus.QUEUED) {
                logger.debug((Object)(token + " got resource"));
                String name = ALLOCATED_RESOURCE_KEY_VARIABLE + token.getId();
                String value = e.getAllocatedResourceKey();
                WorkflowProcess process = token.getProcessInstance();
                ContextInstance c = process.getContextInstance();
                c.setTransientVariable(name, (Object)value);
                c.setTransientVariable("_resource_" + token.getId(), (Object)e.getResource());
                this.getProcessManagerService().dequeue(token);
            } else {
                logger.warn((Object)(token + " spurious resource grant"));
            }
        } else if (event instanceof ResourceRequestRejectedEvent) {
            ResourceRequestRejectedEvent e = (ResourceRequestRejectedEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            if (token.getStatus() == ProcessStatus.QUEUED) {
                logger.warn((Object)(token + " failed due to mismatching protection keys"));
                token.fail();
            } else {
                logger.warn((Object)(token + " - resource request was rejected"));
            }
        } else if (event instanceof QueueOrderChangedEvent) {
            QueueOrderChangedEvent e = (QueueOrderChangedEvent)event;
            CustomToken token = e.getToken();
            WorkflowProcess process = token.getProcessInstance();
            ProcessPriority priority = e.getPriority();
            logger.debug((Object)(token + ", event QUEUE REORDER " + priority));
            if (process.getPriority().equals((Object)priority)) {
                return;
            }
            process.setPriority(priority);
            if (token.isTrace()) {
                this.save(process);
            }
            for (CustomToken t : process.findAllTokens()) {
                if (t.equals((Object)token)) continue;
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)new WorkflowProcessEvent((Object)this, process, (Token)t, WorkflowProcessEventType.PRIORITY_CHANGED));
            }
        } else if (event instanceof ResourceFailedEvent) {
            ResourceFailedEvent e = (ResourceFailedEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            WorkflowProcess process = token.getProcessInstance();
            logger.debug((Object)("[" + process.getId() + "] event RESOURCE FAILURE (" + token.getNode().getName() + ")"));
            ContextInstance c = token.getProcessInstance().getContextInstance();
            c.deleteTransientVariable("_resource_" + token.getId());
            token.setResumeAfterFail(true);
            token.abort();
        } else if (event instanceof ResourceAllocationFailedEvent) {
            ResourceAllocationFailedEvent e = (ResourceAllocationFailedEvent)event;
            DefaultMediator.getInstance().sendAsync((WorkflowEvent)new MessageRejectedEvent((Object)this, e.getToken(), e.getMessage()));
        }
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private void cache(WorkflowProcess process) {
        this.getCache().add((Serializable)Long.valueOf(process.getId()), (Object)process);
        logger.debug((Object)(process.getRootToken() + ", added to cache"));
    }

    private void remove(WorkflowProcess process) {
        this.getCache().remove((Serializable)Long.valueOf(process.getId()));
        logger.debug((Object)(process.getRootToken() + ", removed from cache"));
    }

    private ITimerService getTimerService() {
        return (ITimerService)ServiceRegistry.getDefault().lookup(ITimerService.class);
    }

    static {
        logger = Logger.getLogger(EngineDriver.class);
    }
}

