/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.licensing.file;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.core.licensing.ILicenseReader;
import com.tandbergtv.workflow.core.licensing.InvalidLicenseException;
import com.tandbergtv.workflow.core.licensing.LicenseKey;
import com.tandbergtv.workflow.core.licensing.LicenseKeyConstants;
import com.tandbergtv.workflow.util.encryption.EncryptionUtil;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileLicenseReader
implements ILicenseReader {
    private static final String WORKFLOW_DIR = "workflow";
    private static final String ENCRYPTED_FILE_NAME = "licensekey.lic";
    private static Logger logger = Logger.getLogger(FileLicenseReader.class);

    @Override
    public LicenseKey getLicense(String password) throws InvalidLicenseException {
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File file = configReaderService.getFile(WORKFLOW_DIR, ENCRYPTED_FILE_NAME);
        if (file == null) {
            throw new InvalidLicenseException("License file not found");
        }
        String encrLicenseFilePath = file.getAbsolutePath();
        LicenseKey licenseKey = new LicenseKey();
        EncryptionUtil encUtil = new EncryptionUtil();
        InputStream cis = encUtil.getEncryptedInputStream(password, encrLicenseFilePath);
        HashMap<String, String> licenseMap = new HashMap<String, String>();
        Properties prop = new Properties();
        try {
            prop.loadFromXML(cis);
        }
        catch (Exception e) {
            throw new InvalidLicenseException("Could not read properties from the encrypted input stream", e);
        }
        for (String param : LicenseKeyConstants.licenseParams) {
            String value = prop.getProperty(param);
            licenseMap.put(param, value);
            logger.debug((Object)(param + "-" + value));
        }
        licenseKey.setLicenseMap(licenseMap);
        return licenseKey;
    }
}

