/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.resource;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.resourcemanager.event.AcquireResourceEvent;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class RequestResource
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(RequestResource.class);
    public static final String RESOURCE_ALLOCATION_VAR = "_resource_host";
    private static final long serialVersionUID = -991843493973408120L;

    public void execute(ExecutionContext ec) throws Exception {
        CustomToken token = (CustomToken)ec.getToken();
        token.queue();
        Node node = token.getNode();
        if (node.getSuperState() != null) {
            node = node.getSuperState();
        }
        if (!(node instanceof ResourceGroupAware)) {
            throw new ActionException(token + " cannot request resource for this node: " + node.getName());
        }
        logger.info((Object)(token + " (" + node.getName() + ") trying to acquire resource"));
        Long resourceGroupId = ((ResourceGroupAware)node).getResourceGroupID();
        String allocationKey = this.getResourceAllocationKey(ec);
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new AcquireResourceEvent(this, (Token)token, resourceGroupId, allocationKey));
    }

    private String getResourceAllocationKey(ExecutionContext ec) {
        Object value = ec.getVariable("_resource_host_" + ec.getToken().getId());
        if (value == null) {
            value = ec.getVariable(RESOURCE_ALLOCATION_VAR);
        }
        return value != null ? value.toString() : null;
    }
}

