/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.DriverRuntimeException;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.util.Map;
import org.jbpm.graph.def.ProcessDefinition;

public class ProcessFactory
implements IProcessFactory {
    public WorkflowProcess create(ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = null;
        try {
            process = this.getService().create(template, parameters).getProcessInstance();
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    public WorkflowProcess create(CustomToken token, ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = null;
        try {
            process = this.getService().create(token, template, parameters).getProcessInstance();
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    public WorkflowProcess start(ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = this.create(template, parameters);
        try {
            this.getService().start(process.getRootToken());
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    public WorkflowProcess start(CustomToken token, ProcessDefinition template, Map<String, Object> parameters) {
        WorkflowProcess process = this.create(token, template, parameters);
        try {
            this.getService().start(process.getRootToken());
        }
        catch (DriverException e) {
            throw new DriverRuntimeException(e);
        }
        return process;
    }

    private IProcessManagerService getService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }
}

