/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.timer;

import com.tandbergtv.workflow.core.DurationUtility;
import com.tandbergtv.workflow.core.WFSInterpreter;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import com.tandbergtv.workflow.driver.timer.TokenTimer;
import java.util.Date;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.scheduler.exe.Timer;

public class CreateTimerAction
extends org.jbpm.scheduler.def.CreateTimerAction {
    private Long MIN_TIMEOUT;
    private static final long serialVersionUID = -5891512481051475508L;
    private static final String BUNDLE_NAME = String.valueOf(CreateTimerAction.class.getPackage().getName()) + ".timer";
    private static final Logger logger = Logger.getLogger(CreateTimerAction.class);

    public CreateTimerAction() {
        try {
            String value = ResourceBundle.getBundle(BUNDLE_NAME).getString("process.timeout");
            this.MIN_TIMEOUT = Long.parseLong(value) * 1000L;
        }
        catch (Exception e) {
            this.MIN_TIMEOUT = 120000L;
        }
    }

    public void execute(ExecutionContext context) throws Exception {
        Timer timer = this.createTimer(context);
        ((ITimerService)ServiceRegistry.getDefault().lookup(ITimerService.class)).addTimer(new TokenTimer(timer));
    }

    protected Timer createTimer(ExecutionContext context) {
        Token token = context.getToken();
        Timer timer = new Timer(token);
        timer.setName(this.getTimerName());
        timer.setRepeat(this.getRepeat());
        long dueDateinMillisecs = this.getDurationInMillis(this.getDueDate(), context);
        Date timerDueDate = new Date(new Date().getTime() + dueDateinMillisecs);
        logger.info((Object)(token + ", timer due date: " + timerDueDate + ", duration: " + dueDateinMillisecs / 1000L + " sec"));
        timer.setDueDate(timerDueDate);
        timer.setAction(this.getTimerAction());
        timer.setTransitionName(this.getTransitionName());
        timer.setGraphElement(context.getEventSource());
        timer.setTaskInstance(context.getTaskInstance());
        if (this.getEvent() != null && this.getEvent().getGraphElement() != null) {
            GraphElement graphElement = this.getEvent().getGraphElement();
            try {
                context.setTimer(timer);
                graphElement.fireEvent("timer-create", context);
            }
            finally {
                context.setTimer(null);
            }
        }
        return timer;
    }

    private long getDurationInMillis(String duration, ExecutionContext context) {
        long time = 0L;
        try {
            time = new DurationUtility().getDurationInMillis(duration, new WFSInterpreter(context));
        }
        catch (Exception e) {
            logger.warn((Object)(context.getToken() + " could not parse " + duration + " as a valid date."));
        }
        return time < this.MIN_TIMEOUT ? this.MIN_TIMEOUT : time;
    }
}

