/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command.locate;

import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.command.locate.AbstractTokenLocator;
import com.tandbergtv.workflow.driver.command.locate.TokenLocatorException;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;

public class CompositeKeyMatcher
extends AbstractTokenLocator {
    private static final Logger logger = Logger.getLogger(CompositeKeyMatcher.class);

    @Override
    public Token locate(WorkflowMessage message) throws TokenLocatorException {
        ICacheService cache = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
        for (Serializable id : cache.getKeys()) {
            WorkflowProcess process = (WorkflowProcess)cache.get(id);
            for (CustomToken token : process.findAllTokens()) {
                logger.debug((Object)(token + ", trying to match message " + message.getMessageUID()));
                boolean match = this.correlateToken(message, token);
                if (!match) continue;
                return token;
            }
        }
        return null;
    }

    protected boolean correlateToken(WorkflowMessage message, CustomToken token) throws TokenLocatorException {
        if (token.getStatus() != ProcessStatus.RUNNING && token.getStatus() != ProcessStatus.BUSY && token.getStatus() != ProcessStatus.QUEUED) {
            return false;
        }
        Node node = this.getNode((Token)token);
        if (!this.needsMessage(node, message)) {
            return false;
        }
        Map<String, String> keys = this.getCorrelationKeys(node);
        if (keys.isEmpty()) {
            return false;
        }
        boolean found = true;
        for (String key : keys.keySet()) {
            String name = keys.get(key);
            Object value = token.getProcessInstance().getContextInstance().getVariable(key);
            if (value == null) continue;
            logger.debug((Object)("Variable " + key + " value " + value + " message parameter " + name + " value " + message.getParameterValue(name)));
            boolean bl = found = found && value.toString().equals(message.getParameterValue(name));
        }
        return found;
    }

    private Map<String, String> getCorrelationKeys(Node node) throws TokenLocatorException {
        Map<String, String> keys = new HashMap<String, String>();
        if (!(node instanceof AutomaticTaskNode)) {
            return keys;
        }
        try {
            keys = ((AutomaticTaskNode)AutomaticTaskNode.class.cast(node)).getCorrelationKeys();
        }
        catch (RuntimeException e) {
            throw new TokenLocatorException(e);
        }
        return keys;
    }
}

