/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.event.TaskCreatedEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.event.message.TaskCompleteEvent;
import com.tandbergtv.workflow.driver.event.message.TaskUpdateEvent;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class EventHandler
implements IColleague {
    private static final Logger logger = Logger.getLogger(EventHandler.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$com$tandbergtv$workflow$driver$event$WorkflowProcessEventType;

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        block40: {
            IProgressTrackingStrategy progressTracker;
            block41: {
                Object source = event.getSource();
                if (source == this) {
                    return;
                }
                progressTracker = (IProgressTrackingStrategy)ServiceRegistry.getDefault().lookup(IProgressTrackingStrategy.class);
                IProcessCounter counter = (IProcessCounter)((Object)this.getProcessManagerService().getStatistics().getCumulativeStatistics());
                if (!(event instanceof WorkflowProcessEvent)) break block41;
                WorkflowProcessEvent e = (WorkflowProcessEvent)event;
                CustomToken token = (CustomToken)e.getToken();
                WorkflowProcess process = token.getProcessInstance();
                logger.debug((Object)(token + ", event " + e.getType()));
                switch (EventHandler.$SWITCH_TABLE$com$tandbergtv$workflow$driver$event$WorkflowProcessEventType()[e.getType().ordinal()]) {
                    case 7: {
                        if (token.isRoot()) {
                            this.cache(process);
                        }
                        if (token.isTrace()) {
                            this.save(process);
                            break;
                        }
                        break block40;
                    }
                    case 2: {
                        if (token.isRoot()) {
                            this.cache(process);
                        }
                        if (token.isTrace()) {
                            this.save(process);
                            break;
                        }
                        break block40;
                    }
                    case 4: 
                    case 8: 
                    case 9: {
                        if (token.isTrace()) {
                            this.save(process);
                            break;
                        }
                        break block40;
                    }
                    case 18: {
                        counter.branched(token);
                        this.save(process);
                        break;
                    }
                    case 13: 
                    case 19: {
                        this.save(process);
                        break;
                    }
                    case 3: {
                        counter.enqueued(token);
                        progressTracker.setComplete((Token)token);
                        if (token.isTrace()) {
                            this.save(process);
                            break;
                        }
                        break block40;
                    }
                    case 12: {
                        counter.completed(token);
                        if (token.isTrace() || token.isRoot()) {
                            this.save(process);
                        }
                        if (token.isRoot()) {
                            this.remove(process);
                            break;
                        }
                        break block40;
                    }
                    case 5: 
                    case 10: {
                        if (token.isRoot() && token.isTrace()) {
                            this.save(process);
                            break;
                        }
                        break block40;
                    }
                    case 6: 
                    case 11: {
                        this.getTimerService().deleteTimer((Token)token);
                        this.save(process);
                        if (token.isRoot()) {
                            this.remove(process);
                            break;
                        }
                        break block40;
                    }
                    case 14: {
                        counter.failed(token);
                        this.getTimerService().deleteTimer((Token)token);
                        this.save(process);
                        if (token.isRoot()) {
                            this.remove(process);
                        }
                        try {
                            if (token.isResumeAfterFail()) {
                                logger.debug((Object)(token + " indicates that it wants to be retried"));
                                token.setResumeAfterFail(false);
                                this.getProcessManagerService().resume(token);
                            }
                            break block40;
                        }
                        catch (DriverException t) {
                            logger.warn((Object)(process + " failed to resume"), (Throwable)t);
                        }
                        break;
                    }
                    case 15: {
                        if (token.isTrace()) {
                            this.save(process);
                        }
                        if (!token.isRoot()) break block40;
                        this.remove(process);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block40;
            }
            if (event instanceof TaskUpdateEvent) {
                TaskUpdateEvent e = (TaskUpdateEvent)event;
                CustomToken token = (CustomToken)e.getToken();
                if (token.getStatus() == ProcessStatus.BUSY || token.getStatus() == ProcessStatus.RUNNING) {
                    String percent = e.getPercentComplete();
                    String name = token.getNode().getName();
                    logger.info((Object)(token + " (" + name + ") " + percent + "% complete"));
                    progressTracker.setPercentComplete((Token)token, percent);
                }
            } else if (event instanceof TaskCreatedEvent) {
                TaskCreatedEvent e = (TaskCreatedEvent)event;
                WorkflowProcess process = e.getProcess();
                this.save(process);
            } else if (event instanceof TaskCompleteEvent) {
                TaskCompleteEvent e = (TaskCompleteEvent)event;
                CustomToken token = (CustomToken)e.getToken();
                String name = token.getNode().getName();
                if (token.getStatus() == ProcessStatus.QUEUED && e.hasFailed()) {
                    logger.info((Object)(token + " has failed at (" + name + ")"));
                    token.fail();
                } else {
                    logger.info((Object)(token + " (" + name + ") completed"));
                }
            }
        }
    }

    private IProcessManagerService getProcessManagerService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    private void save(WorkflowProcess process) {
        ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).save(process);
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private void cache(WorkflowProcess process) {
        this.getCache().add((Serializable)Long.valueOf(process.getId()), (Object)process);
        logger.debug((Object)(process.getRootToken() + ", added to cache"));
    }

    private void remove(WorkflowProcess process) {
        this.getCache().remove((Serializable)Long.valueOf(process.getId()));
        logger.debug((Object)(process.getRootToken() + ", removed from cache"));
    }

    private ITimerService getTimerService() {
        return (ITimerService)ServiceRegistry.getDefault().lookup(ITimerService.class);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$tandbergtv$workflow$driver$event$WorkflowProcessEventType() {
        if ($SWITCH_TABLE$com$tandbergtv$workflow$driver$event$WorkflowProcessEventType != null) {
            return $SWITCH_TABLE$com$tandbergtv$workflow$driver$event$WorkflowProcessEventType;
        }
        int[] nArray = new int[WorkflowProcessEventType.values().length];
        try {
            nArray[WorkflowProcessEventType.ACQUIRED.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.BRANCHED.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.CACHE_INITED.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.CANCELLED.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.CANCELLING.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.CHILD.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.CRASHED.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.CREATED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.DELETED.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.DEQUEUED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.FAILED.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.JOINED.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.PAUSED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.PAUSING.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.PRIORITY_CHANGED.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.QUEUED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.RELEASED.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.RESUMED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.STARTED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.STOPPED.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkflowProcessEventType.TIMEOUT.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$tandbergtv$workflow$driver$event$WorkflowProcessEventType = nArray;
        return nArray;
    }
}

