/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.auth.domain.IProtectionKeyAware;
import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.exe.ExecutionContext;
import com.tandbergtv.workflow.core.graph.exe.IExecutable;
import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.graph.node.Decision;
import org.jbpm.graph.node.Fork;
import org.jbpm.graph.node.Join;
import org.jbpm.graph.node.StartState;
import org.jbpm.logging.log.CompositeLog;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class CustomToken
extends Token
implements IProtectionKeyAware {
    private static final long serialVersionUID = -477713728859250114L;
    private static final Logger logger = Logger.getLogger(CustomToken.class);
    private ActionHandler actionHandler;
    private ProcessStatus status;
    private ProcessStatus requestedStatus;
    private boolean resumeAfterFail;
    private boolean isResuming;
    private int retryCount;
    private final Lock lock = new ReentrantLock();
    private Date superStateEnter;
    private transient boolean trace = true;
    private static final String TOKEN_NAME_SEPARATOR = "|";

    protected CustomToken() {
    }

    public CustomToken(ProcessInstance processInstance) {
        super(processInstance);
        this.setRequestedStatus(ProcessStatus.CREATED);
        this.setStatus(ProcessStatus.CREATED);
        this.fireEvent(WorkflowProcessEventType.CREATED);
    }

    public CustomToken(Token parent, String name) {
        super(parent, name);
        this.setRequestedStatus(ProcessStatus.CREATED);
        this.setStatus(ProcessStatus.CREATED);
        this.fireEvent(WorkflowProcessEventType.CREATED);
    }

    public ProcessStatus getRequestedStatus() {
        return this.requestedStatus;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    void setRequestedStatus(ProcessStatus requestedStatus) {
        this.requestedStatus = requestedStatus;
        if (this.isRoot()) {
            this.getProcessInstance().setRequestedStatus(requestedStatus);
        }
    }

    void setStatus(ProcessStatus status) {
        if (this.status != null && status != this.status) {
            logger.info((Object)(this + " -> " + (Object)((Object)status)));
        }
        this.status = status;
        if (this.isRoot()) {
            this.getProcessInstance().setStatus(status);
        }
    }

    public WorkflowProcess getProcessInstance() {
        return (WorkflowProcess)super.getProcessInstance();
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public void setActionHandler(ActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    public boolean isResumeAfterFail() {
        return this.resumeAfterFail;
    }

    public void setResumeAfterFail(boolean resumeAfterFail) {
        if (this.requestedStatus != ProcessStatus.PAUSED && this.requestedStatus != ProcessStatus.CANCELLED) {
            this.resumeAfterFail = resumeAfterFail;
        }
    }

    public Date getSuperStateEnter() {
        return this.superStateEnter;
    }

    public void setSuperStateEnter(Date superStateEnter) {
        this.superStateEnter = superStateEnter;
    }

    public CustomToken getParent() {
        return (CustomToken)this.parent;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isResuming() {
        return this.isResuming;
    }

    public void setResuming(boolean isResuming) {
        this.isResuming = isResuming;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void resetRetryCount() {
        this.retryCount = 0;
    }

    public void incrementRetryCount() {
        ++this.retryCount;
    }

    @Override
    public void addProtectionKey(ProtectionKey key) {
        this.getProcessInstance().addProtectionKey(key);
    }

    @Override
    public Set<ProtectionKey> getProtectionKeys() {
        return this.getProcessInstance().getProtectionKeys();
    }

    public Collection<CustomToken> getChildTokens() {
        if (this.children == null) {
            return new ArrayList<CustomToken>();
        }
        return this.children.values();
    }

    public Collection<CustomToken> getActiveChildTokens() {
        ArrayList<CustomToken> active = new ArrayList<CustomToken>();
        if (this.children == null) {
            return active;
        }
        for (CustomToken child : this.getChildTokens()) {
            if (child.hasEnded()) continue;
            active.add(child);
        }
        return active;
    }

    public Node getCurrentNode() {
        SuperState parent = this.node.getSuperState();
        if (parent != null) {
            return parent;
        }
        return this.node;
    }

    public void addLog(ProcessLog processLog) {
        if (processLog instanceof NodeLog) {
            processLog.setParent(null);
            processLog.setToken((Token)this);
            processLog.setDate(new Date());
            DefaultMediator.getInstance().send((WorkflowEvent)new ProcessLogEvent(this, processLog));
        }
    }

    public void endCompositeLog() {
    }

    public void startCompositeLog(CompositeLog compositeLog) {
    }

    public void signal() {
        logger.debug((Object)(this + " (" + this.node.getName() + ")"));
        if (this.node instanceof StartState) {
            this.setNodeEnter(this.start);
        }
        if (this.status == ProcessStatus.ERROR || this.status == ProcessStatus.PAUSED) {
            this.setStatus(ProcessStatus.RUNNING);
            if (this.node instanceof StartState || this.node instanceof Join) {
                this.node.leave((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
            } else {
                Transition t = this.getArrivingTransition();
                ExecutionContext context = new ExecutionContext(this);
                context.setTransitionSource(t.getFrom());
                context.setTransition(t);
                t.take((org.jbpm.graph.exe.ExecutionContext)context);
            }
            return;
        }
        if (this.node instanceof AutomaticTaskNode) {
            this.enterNode();
        } else if (this.node instanceof ManualTaskNode) {
            if (this.getStatus() == ProcessStatus.BUSY) {
                this.node.leave((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
            } else {
                this.enterNode();
            }
        } else if (this.node instanceof Decision) {
            this.enterNode();
        } else if (this.node instanceof Fork) {
            String transitionName = this.name.substring(0, this.name.indexOf(TOKEN_NAME_SEPARATOR));
            this.node.leave((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this), transitionName);
        } else if (this.node instanceof Join || this.node instanceof StartState) {
            this.node.leave((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
        } else {
            logger.warn((Object)(this + ", calling Token.signal() (" + this.node.getName() + ")"));
            super.signal();
        }
    }

    public WorkflowProcess createSubProcessInstance(ProcessDefinition template) {
        this.subProcessInstance = new WorkflowProcess(template, this.getProcessInstance().getPriority());
        this.setSubProcessInstance(this.subProcessInstance);
        this.subProcessInstance.setSuperProcessToken((Token)this);
        return (WorkflowProcess)this.subProcessInstance;
    }

    public void start() {
        if (this.status != ProcessStatus.CREATED) {
            throw new InvalidProcessStateException(this.toString());
        }
        this.takelock();
        try {
            this.setStatus(ProcessStatus.RUNNING);
            this.setRequestedStatus(ProcessStatus.RUNNING);
            this.fireEvent(WorkflowProcessEventType.STARTED);
            this.signal();
        }
        finally {
            this.releaselock();
        }
    }

    public void suspend() {
        if (this.status == ProcessStatus.CANCELLED || this.requestedStatus == ProcessStatus.CANCELLED || this.status == ProcessStatus.ERROR || this.requestedStatus == ProcessStatus.ERROR || this.requestedStatus == ProcessStatus.PAUSED || this.status == ProcessStatus.COMPLETED) {
            return;
        }
        logger.info((Object)(this + " attempting to pause..."));
        this.setRequestedStatus(ProcessStatus.PAUSED);
        this.fireEvent(WorkflowProcessEventType.PAUSING);
        this.takelock();
        try {
            if (this.getNode() instanceof ManualTaskNode) {
                this.closeTaskInstance();
            }
            this.suspend(new ExecutionContext(this));
            if (this.status == ProcessStatus.COMPLETED || this.status == ProcessStatus.CANCELLED || this.status == ProcessStatus.ERROR) {
                return;
            }
            this.setStatus(ProcessStatus.PAUSED);
            this.setRequestedStatus(ProcessStatus.PAUSED);
        }
        finally {
            this.releaselock();
        }
        this.fireEvent(WorkflowProcessEventType.PAUSED);
    }

    private void suspend(ExecutionContext context) {
        ActionHandler handler = (ActionHandler)JbpmConfiguration.Configs.getObject((String)"jbpm.token.suspend.command");
        try {
            handler.execute((org.jbpm.graph.exe.ExecutionContext)context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resume() {
        this.check();
        if (this.status != ProcessStatus.PAUSED && this.status != ProcessStatus.ERROR && this.status != ProcessStatus.BRANCHED) {
            return;
        }
        logger.debug((Object)(this + " attempting to resume..."));
        this.takelock();
        try {
            if (this.hasActiveChildren()) {
                this.setRequestedStatus(ProcessStatus.BRANCHED);
                this.setStatus(ProcessStatus.BRANCHED);
                this.fireEvent(WorkflowProcessEventType.RESUMED);
                for (CustomToken child : this.getActiveChildTokens()) {
                    child.resume();
                }
            } else {
                super.resume();
                this.setResuming(true);
                this.setRequestedStatus(ProcessStatus.RUNNING);
                this.fireEvent(WorkflowProcessEventType.RESUMED);
                this.signal();
            }
        }
        finally {
            this.releaselock();
        }
    }

    public void queue() {
        this.setRequestedStatus(ProcessStatus.QUEUED);
        this.setStatus(ProcessStatus.QUEUED);
        this.fireEvent(WorkflowProcessEventType.QUEUED);
    }

    public void dequeue() {
        if (this.status != ProcessStatus.QUEUED) {
            throw new InvalidProcessStateException(this.toString());
        }
        this.takelock();
        try {
            this.setStatus(ProcessStatus.RUNNING);
            this.setRequestedStatus(this.status);
            this.fireEvent(WorkflowProcessEventType.DEQUEUED);
            this.signal();
        }
        finally {
            this.releaselock();
        }
    }

    public void fork() {
        this.setStatus(ProcessStatus.BRANCHED);
        this.setRequestedStatus(ProcessStatus.BRANCHED);
        this.fireEvent(WorkflowProcessEventType.BRANCHED);
    }

    public void join() {
        if (this.status != ProcessStatus.BRANCHED) {
            throw new InvalidProcessStateException(this.toString());
        }
        if (this.requestedStatus == ProcessStatus.PAUSED || this.requestedStatus == ProcessStatus.CANCELLED) {
            return;
        }
        this.takelock();
        try {
            this.setStatus(ProcessStatus.RUNNING);
            this.setRequestedStatus(ProcessStatus.RUNNING);
            this.fireEvent(WorkflowProcessEventType.JOINED);
            this.signal();
        }
        finally {
            this.releaselock();
        }
    }

    public void fail() {
        this.closeTaskInstance();
        this.setRequestedStatus(ProcessStatus.ERROR);
        this.setStatus(ProcessStatus.ERROR);
        this.fireEvent(WorkflowProcessEventType.FAILED);
    }

    public void abort() {
        this.setRequestedStatus(ProcessStatus.ERROR);
        Node node = this.getNode();
        if (node instanceof AutomaticTaskNode) {
            ActionHandler handler = this.getActionHandler();
            if (handler instanceof IExecutable) {
                ((IExecutable)handler).abort();
            }
        } else {
            this.fail();
        }
    }

    public void recover() {
        if (this.status != ProcessStatus.CREATED && this.status != ProcessStatus.RUNNING && this.status != ProcessStatus.BUSY && this.status != ProcessStatus.BRANCHED) {
            return;
        }
        if (this.requestedStatus == ProcessStatus.PAUSED) {
            logger.info((Object)(this + ", pausing..."));
            this.resetRequestedStatus();
            this.suspend();
            return;
        }
        if (this.requestedStatus == ProcessStatus.CANCELLED) {
            logger.info((Object)(this + ", cancelling..."));
            this.resetRequestedStatus();
            this.cancel();
            return;
        }
        if (this.status == ProcessStatus.BRANCHED) {
            for (CustomToken token : this.getActiveChildTokens()) {
                token.recover();
            }
        } else {
            logger.info((Object)(this + ", performing crash recovery"));
            this.closeTaskInstance();
            this.setRequestedStatus(ProcessStatus.ERROR);
            this.setStatus(ProcessStatus.ERROR);
            this.fireEvent(WorkflowProcessEventType.CRASHED);
            this.resume();
        }
    }

    public void acquire() {
        this.setStatus(ProcessStatus.BUSY);
        this.fireEvent(WorkflowProcessEventType.ACQUIRED);
    }

    public void release() {
        this.setStatus(ProcessStatus.RUNNING);
        this.fireEvent(WorkflowProcessEventType.RELEASED);
    }

    public void cancel() {
        this.check();
        if (this.status == ProcessStatus.COMPLETED || this.status == ProcessStatus.CANCELLED || this.requestedStatus == ProcessStatus.CANCELLED) {
            return;
        }
        logger.debug((Object)(this + " attempting to cancel..."));
        this.setRequestedStatus(ProcessStatus.CANCELLED);
        this.fireEvent(WorkflowProcessEventType.CANCELLING);
        this.takelock();
        try {
            if (this.status == ProcessStatus.COMPLETED || this.status == ProcessStatus.CANCELLED) {
                return;
            }
            this.setRequestedStatus(ProcessStatus.CANCELLED);
            this.end();
        }
        finally {
            this.releaselock();
        }
    }

    public void end() {
        if (this.hasEnded()) {
            return;
        }
        if (this.requestedStatus == ProcessStatus.CANCELLED) {
            this.end(new ExecutionContext(this));
            this.setStatus(ProcessStatus.CANCELLED);
            this.setRequestedStatus(ProcessStatus.CANCELLED);
            this.end = new Date();
            if (this.isRoot()) {
                this.processInstance.end();
            }
            this.fireEvent(WorkflowProcessEventType.CANCELLED);
        } else {
            this.setAbleToReactivateParent(false);
            this.setStatus(ProcessStatus.COMPLETED);
            this.setRequestedStatus(ProcessStatus.COMPLETED);
            this.end = new Date();
            if (this.isRoot()) {
                this.processInstance.end();
            }
            this.fireEvent(WorkflowProcessEventType.STOPPED);
        }
    }

    private void end(ExecutionContext context) {
        ActionHandler handler = (ActionHandler)JbpmConfiguration.Configs.getObject((String)"jbpm.token.end.command");
        try {
            handler.execute((org.jbpm.graph.exe.ExecutionContext)context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetRequestedStatus() {
        this.requestedStatus = ProcessStatus.RUNNING;
        for (CustomToken token : this.getActiveChildTokens()) {
            ProcessStatus status = token.status;
            if (status != ProcessStatus.RUNNING && status != ProcessStatus.BUSY && status != ProcessStatus.CREATED) continue;
            token.setRequestedStatus(ProcessStatus.RUNNING);
        }
    }

    private void check() {
        if (!this.getProcessInstance().isActive()) {
            throw new InvalidProcessStateException(this.toString());
        }
    }

    private void fireEvent(WorkflowProcessEventType type) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowProcessEvent(this.getProcessInstance(), this, type));
    }

    private Transition getArrivingTransition() {
        Node checkpoint = this.node;
        SuperState parent = this.node.getSuperState();
        if (parent != null) {
            checkpoint = ((NodeGroup)parent).first();
        }
        Set transitions = checkpoint.getArrivingTransitions();
        if (parent == null) {
            return (Transition)transitions.iterator().next();
        }
        for (Transition trans : transitions) {
            if (trans.getFrom().getSuperState() != null && trans.getFrom().getSuperState() == parent) continue;
            return trans;
        }
        return null;
    }

    private void closeTaskInstance() {
        TaskMgmtInstance tmi = this.processInstance.getTaskMgmtInstance();
        if (tmi == null) {
            return;
        }
        Collection instances = tmi.getTaskInstances();
        if (instances == null) {
            return;
        }
        for (TaskInstance ti : instances) {
            if (ti.hasEnded() || !this.equals(ti.getToken())) continue;
            ti.setSignalling(false);
            ti.end();
        }
    }

    private void takelock() {
        this.lock.lock();
        logger.debug((Object)(this + " locked"));
    }

    private void releaselock() {
        this.lock.unlock();
        logger.debug((Object)(this + " unlocked"));
    }

    public String toString() {
        return "[" + this.processInstance.getId() + ":" + this.getId() + "] " + (Object)((Object)this.status);
    }

    protected void enterNode() {
        if (this.node.getSuperState() != null) {
            this.node.getSuperState().enter((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
        } else {
            this.node.enter((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
        }
    }
}

