/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.auth.domain.IProtectionKeyAware;
import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSVariableInstance;
import com.tandbergtv.workflow.core.WorkflowProcessNote;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.RuntimeAction;
import org.jbpm.instantiation.Delegation;

public class WorkflowProcess
extends ProcessInstance
implements IProtectionKeyAware {
    private static final long serialVersionUID = 5496751459211432922L;
    private ProcessStatus status;
    private ProcessStatus requestedStatus;
    private ProcessPriority priority;
    private WorkflowProcessNote note;
    private Set<WFSVariableInstance> variables = new HashSet<WFSVariableInstance>();
    private boolean active = true;
    private static final Logger logger = Logger.getLogger(WorkflowProcess.class);
    private Lock lock;

    protected WorkflowProcess() {
        this.lock = new ReentrantLock();
    }

    public WorkflowProcess(ProcessDefinition processDefinition, ProcessPriority processPriority) {
        super(processDefinition);
        this.priority = processPriority;
        this.rootToken = new CustomToken(this);
        this.lock = new ReentrantLock();
        this.addRuntimeActions();
    }

    public WorkflowTemplate getProcessDefinition() {
        return (WorkflowTemplate)super.getProcessDefinition();
    }

    public CustomToken getRootToken() {
        return (CustomToken)this.rootToken;
    }

    ProcessStatus getStatus() {
        return this.status;
    }

    void setStatus(ProcessStatus status) {
        if (this.status != null && status != this.status) {
            logger.debug((Object)(this + " -> " + (Object)((Object)status)));
        }
        this.status = status;
    }

    ProcessStatus getRequestedStatus() {
        return this.requestedStatus;
    }

    void setRequestedStatus(ProcessStatus requestedStatus) {
        this.requestedStatus = requestedStatus;
    }

    public ProcessPriority getPriority() {
        return this.priority;
    }

    public void setPriority(ProcessPriority priority) {
        this.priority = priority;
    }

    public WorkflowProcessNote getNote() {
        return this.note;
    }

    public void setNote(WorkflowProcessNote note) {
        this.note = note;
        this.note.setProcess(this);
    }

    public Set<WFSVariableInstance> getVariables() {
        return this.variables;
    }

    private void setVariables(Set<WFSVariableInstance> variables) {
        this.variables = variables;
    }

    @Override
    public void addProtectionKey(ProtectionKey key) {
        throw new UnsupportedOperationException(this + ", adding protection keys is not permitted");
    }

    @Override
    public Set<ProtectionKey> getProtectionKeys() {
        return this.getProcessDefinition().getProtectionKeys();
    }

    public boolean isActive() {
        return this.active;
    }

    public void delete() {
        if (!this.getCanBeDeleted()) {
            throw new InvalidProcessStateException(this.toString());
        }
        this.active = false;
        this.fireEvent(WorkflowProcessEventType.DELETED);
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean getCanBeDeleted() {
        ProcessStatus status = this.getRootToken().getStatus();
        return status == ProcessStatus.CANCELLED || status == ProcessStatus.ERROR || status == ProcessStatus.COMPLETED;
    }

    public boolean getCanBePaused() {
        ProcessStatus status = this.getRootToken().getStatus();
        ProcessStatus requestedStatus = this.getRootToken().getRequestedStatus();
        return status != ProcessStatus.PAUSED && requestedStatus != ProcessStatus.PAUSED && status != ProcessStatus.CANCELLED && requestedStatus != ProcessStatus.CANCELLED && status != ProcessStatus.ERROR && status != ProcessStatus.COMPLETED;
    }

    public boolean getCanBeResumed() {
        return this.getRootToken().getStatus() == ProcessStatus.PAUSED;
    }

    public boolean getCanBeRetried() {
        ProcessStatus status = this.getRootToken().getStatus();
        if (status == ProcessStatus.ERROR) {
            return true;
        }
        boolean failed = false;
        for (CustomToken token : this.findAllTokens()) {
            boolean bl = failed = failed || !token.isRoot() && token.getStatus() == ProcessStatus.ERROR && status == ProcessStatus.BRANCHED;
        }
        return failed;
    }

    public boolean getCanBeCancelled() {
        ProcessStatus status = this.getRootToken().getStatus();
        ProcessStatus requestedStatus = this.getRootToken().getRequestedStatus();
        return status != ProcessStatus.CANCELLED && requestedStatus != ProcessStatus.CANCELLED && status != ProcessStatus.COMPLETED;
    }

    public boolean getCanBeRestarted() {
        ProcessStatus status = this.getRootToken().getStatus();
        return status == ProcessStatus.COMPLETED || status == ProcessStatus.CANCELLED || status == ProcessStatus.ERROR;
    }

    public List<CustomToken> findAllTokens() {
        ArrayList<CustomToken> tokens = new ArrayList();
        try {
            tokens = super.findAllTokens();
        }
        catch (ConcurrentModificationException e) {
            logger.warn((Object)(this.rootToken + ", ignoring " + e.getMessage()), (Throwable)e);
        }
        return tokens;
    }

    public void addRuntimeActions() {
        if (this.runtimeActions != null && !this.runtimeActions.isEmpty()) {
            return;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(this.getClass().getPackage().getName()) + ".event");
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String event = e.nextElement();
            Delegation delegate = new Delegation(bundle.getString(event));
            this.addRuntimeAction(new RuntimeAction((GraphElement)this.processDefinition, event, new Action(delegate)));
        }
    }

    private void fireEvent(WorkflowProcessEventType type) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowProcessEvent((Object)this, this, type));
    }

    public String toString() {
        return "[" + this.getId() + "] " + (Object)((Object)this.status);
    }
}

