/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph.exe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;

public class ListVariableInstance
extends VariableInstance {
    private static final long serialVersionUID = 5567529337015616053L;
    protected final String value = "LIST";
    public static final String START_TOKEN = "[";
    public static final String END_TOKEN = "]";

    public boolean isStorable(Object value) {
        return value instanceof List;
    }

    protected Object getObject() {
        ContextInstance ci = this.token.getProcessInstance().getContextInstance();
        TokenVariableMap map = ci.getTokenVariableMap(this.token);
        TreeMap<Integer, String> sorted = new TreeMap<Integer, String>();
        for (VariableInstance variable : map.getVariableInstances().values()) {
            if (!variable.getName().startsWith(String.valueOf(this.name) + START_TOKEN)) continue;
            Integer index = this.index(variable.getName());
            sorted.put(index, variable.getValue().toString());
        }
        return new ArrayList(sorted.values());
    }

    protected void setObject(Object value) {
        ContextInstance ci = this.token.getProcessInstance().getContextInstance();
        this.removeListVariables(ci);
        List list = (List)value;
        int i = 0;
        while (i < list.size()) {
            ci.setVariable(String.valueOf(this.name) + START_TOKEN + i + END_TOKEN, list.get(i), this.token);
            ++i;
        }
    }

    private void removeListVariables(ContextInstance ci) {
        Map variables;
        TokenVariableMap map = ci.getTokenVariableMap(this.token);
        if (map != null && (variables = map.getVariableInstances()) != null) {
            Iterator i = variables.values().iterator();
            while (i.hasNext()) {
                VariableInstance variable = (VariableInstance)i.next();
                if (!variable.getName().startsWith(String.valueOf(this.name) + START_TOKEN)) continue;
                i.remove();
            }
        }
    }

    private Integer index(String name) {
        int start = name.indexOf(START_TOKEN);
        int end = name.indexOf(END_TOKEN);
        return Integer.valueOf(name.substring(start + 1, end));
    }
}

