/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.graph.IProcessFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.DelegationException;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.graph.node.SubProcessResolver;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Exec
extends ProcessState {
    private static final long serialVersionUID = -5608286665493465148L;
    private static final Logger logger = Logger.getLogger(Exec.class);

    public Set<?> getVariableAccesses() {
        return this.variableAccesses;
    }

    public void read(Element element, JpdlXmlReader reader) {
        Element e = element.element("sub-process");
        SubProcessResolver subProcessResolver = (SubProcessResolver)JbpmConfiguration.Configs.getObject((String)"jbpm.sub.process.resolver");
        this.subProcessDefinition = subProcessResolver.findSubProcess(e);
        if (this.subProcessDefinition == null) {
            reader.addError("Template " + e.attributeValue("name") + " not found");
            return;
        }
        this.variableAccesses = new HashSet(reader.readVariableAccesses(element));
    }

    public void enter(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        token.acquire();
        if (token.getSubProcessInstance() != null) {
            return;
        }
        logger.info((Object)(token + " (" + this.name + ")"));
        super.enter(context);
    }

    public void execute(ExecutionContext context) {
        CustomToken token = (CustomToken)context.getToken();
        logger.info((Object)(token + " (" + this.name + ")"));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ContextInstance contextInstance = token.getProcessInstance().getContextInstance();
        for (VariableAccess variable : this.variableAccesses) {
            if (!variable.isReadable()) continue;
            Object value = contextInstance.getVariable(variable.getVariableName(), (Token)token);
            logger.debug((Object)(token + ", copying " + variable.getVariableName() + ", " + value + " to child"));
            parameters.put(variable.getMappedName(), value);
        }
        try {
            IProcessFactory factory = (IProcessFactory)JbpmConfiguration.Configs.getObject((String)"jbpm.process.factory");
            factory.start(token, this.subProcessDefinition, parameters);
        }
        catch (Throwable t) {
            try {
                this.raiseException(t, context);
            }
            catch (DelegationException e) {
                logger.warn((Object)(token + ", no exception handler defined for template - " + this.getProcessDefinition().getName()));
                token.fail();
            }
        }
    }

    public void leave(ExecutionContext context, Transition transition) {
        CustomToken token = (CustomToken)context.getToken();
        logger.info((Object)(token + " (" + this.name + ")"));
        token.release();
        context.setSubProcessInstance((ProcessInstance)token.getSubProcessInstance());
        super.leave(context, this.getDefaultLeavingTransition());
    }
}

