/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.TypeConversionException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class DatatypeConverter {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");

    public Object convert(Object input, Datatype type) throws TypeConversionException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        Object ret = input.toString();
        try {
            switch (type) {
                case INT: {
                    ret = Integer.valueOf(input.toString());
                    break;
                }
                case BOOLEAN: {
                    ret = Boolean.valueOf(input.toString());
                    break;
                }
                case DATE: {
                    ret = this.dateformat.parse(input.toString());
                    break;
                }
                case DURATION: {
                    break;
                }
                case LIST: {
                    ret = input;
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new TypeConversionException("Failed to convert " + input + " to type " + (Object)((Object)type), e);
        }
        return ret;
    }
}

