/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.auth.domain.IProtectionKeyAware;
import com.tandbergtv.workflow.auth.domain.ProtectionKey;
import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.IUndoableNode;
import com.tandbergtv.workflow.core.graph.exe.ExecutionContext;
import com.tandbergtv.workflow.core.graph.exe.ExecutionContextSnapshot;
import com.tandbergtv.workflow.core.graph.exe.IExecutable;
import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.graph.node.Decision;
import org.jbpm.graph.node.Fork;
import org.jbpm.graph.node.Join;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.graph.node.StartState;
import org.jbpm.logging.log.CompositeLog;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class CustomToken
extends Token
implements IProtectionKeyAware,
ResourceGroupAware {
    private static final long serialVersionUID = -477713728859250114L;
    private static final Logger logger = Logger.getLogger(CustomToken.class);
    private transient ActionHandler actionHandler;
    private ProcessStatus status;
    private ProcessStatus requestedStatus;
    private boolean resumeAfterFail;
    private boolean isResuming;
    private int retryCount;
    private String completion;
    private transient Deque<ExecutionContext> contextStack;
    private final Lock lock = new ReentrantLock();
    private Date superStateEnter;
    private static final String TOKEN_NAME_SEPARATOR = "|";

    protected CustomToken() {
        this.contextStack = new ArrayDeque<ExecutionContext>();
    }

    public CustomToken(ProcessInstance processInstance) {
        super(processInstance);
        this.setRequestedStatus(ProcessStatus.CREATED);
        this.setStatus(ProcessStatus.CREATED);
        this.contextStack = new ArrayDeque<ExecutionContext>();
        this.fireEvent(WorkflowProcessEventType.CREATED);
    }

    public CustomToken(CustomToken parent, String name) {
        super((Token)parent, name);
        this.setRequestedStatus(ProcessStatus.CREATED);
        this.setStatus(ProcessStatus.CREATED);
        this.contextStack = new ArrayDeque<ExecutionContext>();
        this.fireEvent(WorkflowProcessEventType.CREATED);
    }

    public ProcessStatus getRequestedStatus() {
        return this.requestedStatus;
    }

    public ProcessStatus getStatus() {
        return this.status;
    }

    void setRequestedStatus(ProcessStatus requestedStatus) {
        this.requestedStatus = requestedStatus;
        if (this.isRoot()) {
            this.getProcessInstance().setRequestedStatus(requestedStatus);
        }
    }

    void setStatus(ProcessStatus status) {
        if (this.status != null && status != this.status) {
            logger.info((Object)(this + " -> " + (Object)((Object)status)));
        }
        this.status = status;
        if (this.isRoot()) {
            this.getProcessInstance().setStatus(status);
        }
    }

    public WorkflowProcess getProcessInstance() {
        return (WorkflowProcess)super.getProcessInstance();
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public void setActionHandler(ActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    public boolean isResumeAfterFail() {
        return this.resumeAfterFail;
    }

    public void setResumeAfterFail(boolean resumeAfterFail) {
        if (this.requestedStatus != ProcessStatus.PAUSED && this.requestedStatus != ProcessStatus.CANCELLED) {
            this.resumeAfterFail = resumeAfterFail;
        }
    }

    public Date getSuperStateEnter() {
        return this.superStateEnter;
    }

    public void setSuperStateEnter(Date superStateEnter) {
        this.superStateEnter = superStateEnter;
    }

    public CustomToken getParent() {
        return (CustomToken)this.parent;
    }

    public WorkflowProcess getSubProcessInstance() {
        return (WorkflowProcess)super.getSubProcessInstance();
    }

    public boolean isResuming() {
        return this.isResuming;
    }

    public void setResuming(boolean isResuming) {
        this.isResuming = isResuming;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void resetRetryCount() {
        this.retryCount = 0;
    }

    public void incrementRetryCount() {
        ++this.retryCount;
    }

    public String getCompletion() {
        return this.completion;
    }

    public void setCompletion(String completion) {
        this.completion = completion;
    }

    @Override
    public void addProtectionKey(ProtectionKey key) {
        this.getProcessInstance().addProtectionKey(key);
    }

    @Override
    public Set<ProtectionKey> getProtectionKeys() {
        return this.getProcessInstance().getProtectionKeys();
    }

    public Collection<CustomToken> getChildTokens() {
        if (this.children == null) {
            return new ArrayList<CustomToken>();
        }
        return this.children.values();
    }

    public Collection<CustomToken> getActiveChildTokens() {
        ArrayList<CustomToken> active = new ArrayList<CustomToken>();
        if (this.children == null) {
            return active;
        }
        for (CustomToken child : this.getChildTokens()) {
            if (child.hasEnded()) continue;
            active.add(child);
        }
        return active;
    }

    public Collection<CustomToken> getCurrentChildTokens() {
        if (this.status != ProcessStatus.BRANCHED) {
            return Collections.emptySet();
        }
        HashSet<CustomToken> current = new HashSet<CustomToken>();
        for (CustomToken child : this.getChildTokens()) {
            String transitionName = child.name.substring(0, child.name.indexOf(TOKEN_NAME_SEPARATOR));
            if (!this.node.hasLeavingTransition(transitionName)) continue;
            current.add(child);
        }
        return current;
    }

    public Node getCurrentNode() {
        SuperState parent = this.node.getSuperState();
        if (parent != null) {
            return parent;
        }
        return this.node;
    }

    @Override
    public Long getResourceGroupID() {
        Long resourceGroupId = null;
        Node node = this.getCurrentNode();
        if (node instanceof ResourceGroupAware) {
            resourceGroupId = ((ResourceGroupAware)node).getResourceGroupID();
        }
        return resourceGroupId;
    }

    @Override
    public void setResourceGroupID(Long resourceGroupID) {
        throw new RuntimeException("Operation not permitted");
    }

    public void pushContext(org.jbpm.graph.exe.ExecutionContext context) {
        if (!(this.node instanceof IUndoableNode)) {
            return;
        }
        IUndoableNode undoable = (IUndoableNode)IUndoableNode.class.cast(this.node);
        if (undoable.canUndo()) {
            this.contextStack.addFirst(new ExecutionContextSnapshot(context));
        }
    }

    protected ExecutionContext popContext() {
        if (this.contextStack.isEmpty()) {
            return null;
        }
        return this.contextStack.removeFirst();
    }

    public void addLog(ProcessLog processLog) {
        if (processLog instanceof NodeLog) {
            processLog.setParent(null);
            processLog.setToken((Token)this);
            processLog.setDate(new Date());
            DefaultMediator.getInstance().send((WorkflowEvent)new ProcessLogEvent(this, processLog));
        }
    }

    public void endCompositeLog() {
    }

    public void startCompositeLog(CompositeLog compositeLog) {
    }

    public void signal() {
        logger.debug((Object)(this + " (" + this.node.getName() + ")"));
        if (this.node instanceof StartState) {
            this.setNodeEnter(this.start);
        }
        if (this.status == ProcessStatus.ERROR || this.status == ProcessStatus.PAUSED) {
            this.setStatus(ProcessStatus.RUNNING);
            if (this.node instanceof StartState || this.node instanceof Join) {
                this.node.leave((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
            } else {
                Transition t = this.getArrivingTransition();
                ExecutionContext context = new ExecutionContext(this);
                context.setTransitionSource(t.getFrom());
                context.setTransition(t);
                t.take((org.jbpm.graph.exe.ExecutionContext)context);
            }
            return;
        }
        if (this.node instanceof AutomaticTaskNode || this.node instanceof Decision) {
            this.enterNode();
        } else if (this.node instanceof ManualTaskNode) {
            if (this.getStatus() == ProcessStatus.BUSY) {
                this.node.leave((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
            } else {
                this.enterNode();
            }
        } else if (this.node instanceof Fork) {
            String transitionName = this.name.substring(0, this.name.indexOf(TOKEN_NAME_SEPARATOR));
            this.node.leave((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this), transitionName);
        } else {
            this.node.leave((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
        }
    }

    public void signal2() {
        logger.debug((Object)(this + " (" + this.node.getName() + ")"));
        this.takelock();
        try {
            if (!(this.node instanceof ProcessState)) {
                throw new InvalidProcessStateException(this + " is not at a ProcessState node");
            }
            this.signal();
        }
        finally {
            this.releaselock();
        }
    }

    protected void enterNode() {
        if (this.node.getSuperState() != null) {
            this.node.getSuperState().enter((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
        } else {
            this.node.enter((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
        }
    }

    public WorkflowProcess createSubProcessInstance(ProcessDefinition template) {
        this.subProcessInstance = new WorkflowProcess(template, this.getProcessInstance().getPriority());
        this.setSubProcessInstance(this.subProcessInstance);
        this.subProcessInstance.setSuperProcessToken((Token)this);
        this.fireEvent(WorkflowProcessEventType.CHILD);
        return (WorkflowProcess)this.subProcessInstance;
    }

    public void start() {
        if (this.status != ProcessStatus.CREATED) {
            throw new InvalidProcessStateException(this.toString());
        }
        this.takelock();
        try {
            if (!(this.node instanceof StartState || this.node instanceof Fork && this.hasParent())) {
                throw new InvalidProcessStateException(this + " (" + this.node.getName() + ")");
            }
            this.setStatus(ProcessStatus.RUNNING);
            this.setRequestedStatus(ProcessStatus.RUNNING);
            this.fireEvent(WorkflowProcessEventType.STARTED);
            this.signal();
        }
        finally {
            this.releaselock();
        }
    }

    public void suspend() {
        if (this.status == ProcessStatus.CANCELLED || this.requestedStatus == ProcessStatus.CANCELLED || this.status == ProcessStatus.ERROR || this.requestedStatus == ProcessStatus.ERROR || this.requestedStatus == ProcessStatus.PAUSED || this.status == ProcessStatus.COMPLETED) {
            return;
        }
        logger.info((Object)(this + " attempting to pause..."));
        this.setRequestedStatus(ProcessStatus.PAUSED);
        this.fireEvent(WorkflowProcessEventType.PAUSING);
        this.takelock();
        try {
            if (this.getNode() instanceof ManualTaskNode) {
                this.closeTaskInstance();
            }
            this.suspend(new ExecutionContext(this));
            if (this.status == ProcessStatus.COMPLETED || this.status == ProcessStatus.CANCELLED || this.status == ProcessStatus.ERROR) {
                return;
            }
            this.setStatus(ProcessStatus.PAUSED);
            this.setRequestedStatus(ProcessStatus.PAUSED);
        }
        finally {
            this.releaselock();
        }
        this.fireEvent(WorkflowProcessEventType.PAUSED);
    }

    private void suspend(ExecutionContext context) {
        ActionHandler handler = (ActionHandler)JbpmConfiguration.Configs.getObject((String)"jbpm.token.suspend.command");
        try {
            handler.execute((org.jbpm.graph.exe.ExecutionContext)context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resume() {
        this.check();
        if (this.status != ProcessStatus.PAUSED && this.status != ProcessStatus.ERROR && this.status != ProcessStatus.BRANCHED) {
            return;
        }
        logger.debug((Object)(this + " attempting to resume..."));
        this.takelock();
        try {
            if (this.hasActiveChildren()) {
                this.setRequestedStatus(ProcessStatus.BRANCHED);
                this.setStatus(ProcessStatus.BRANCHED);
                this.fireEvent(WorkflowProcessEventType.RESUMED);
                this.resume(new ExecutionContext(this));
            } else {
                super.resume();
                this.setResuming(true);
                this.setRequestedStatus(ProcessStatus.RUNNING);
                this.fireEvent(WorkflowProcessEventType.RESUMED);
                this.signal();
                this.resume(new ExecutionContext(this));
            }
        }
        finally {
            this.releaselock();
        }
    }

    private void resume(ExecutionContext context) {
        ActionHandler handler = (ActionHandler)JbpmConfiguration.Configs.getObject((String)"jbpm.token.resume.command");
        try {
            handler.execute((org.jbpm.graph.exe.ExecutionContext)context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void queue() {
        this.setRequestedStatus(ProcessStatus.QUEUED);
        this.setStatus(ProcessStatus.QUEUED);
        this.fireEvent(WorkflowProcessEventType.QUEUED);
    }

    public void dequeue() {
        if (this.status != ProcessStatus.QUEUED) {
            throw new InvalidProcessStateException(this.toString());
        }
        this.takelock();
        try {
            if (this.status != ProcessStatus.QUEUED) {
                throw new InvalidProcessStateException(this.toString());
            }
            this.setStatus(ProcessStatus.RUNNING);
            this.setRequestedStatus(this.status);
            this.fireEvent(WorkflowProcessEventType.DEQUEUED);
            this.signal();
        }
        finally {
            this.releaselock();
        }
    }

    public void fork() {
        this.setStatus(ProcessStatus.BRANCHED);
        this.setRequestedStatus(ProcessStatus.BRANCHED);
        this.fireEvent(WorkflowProcessEventType.BRANCHED);
    }

    public void join(CustomToken child) {
        if (this.status != ProcessStatus.BRANCHED) {
            throw new InvalidProcessStateException(this.toString());
        }
        if (this.requestedStatus == ProcessStatus.PAUSED || this.requestedStatus == ProcessStatus.CANCELLED) {
            return;
        }
        this.takelock();
        try {
            child.setAbleToReactivateParent(false);
            Join join = (Join)child.getNode();
            boolean reactivate = join.mustParentBeReactivated((Token)this, this.getChildren().keySet().iterator());
            if (reactivate) {
                this.setNode((Node)join);
                this.setStatus(ProcessStatus.RUNNING);
                this.setRequestedStatus(ProcessStatus.RUNNING);
                this.fireEvent(WorkflowProcessEventType.JOINED);
                this.signal();
            }
        }
        finally {
            this.releaselock();
        }
    }

    public void fail() {
        this.closeTaskInstance();
        this.setRequestedStatus(ProcessStatus.ERROR);
        this.setStatus(ProcessStatus.ERROR);
        this.fireEvent(WorkflowProcessEventType.FAILED);
        this.fail(new ExecutionContext(this));
    }

    public void fail(Throwable t) {
        this.closeTaskInstance();
        this.setRequestedStatus(ProcessStatus.ERROR);
        this.setStatus(ProcessStatus.ERROR);
        this.fireFailureEvent(t);
        this.fail(new ExecutionContext(this));
    }

    private void fail(ExecutionContext context) {
        ActionHandler handler = (ActionHandler)JbpmConfiguration.Configs.getObject((String)"jbpm.token.fail.command");
        try {
            handler.execute((org.jbpm.graph.exe.ExecutionContext)context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void abort() {
        this.setRequestedStatus(ProcessStatus.ERROR);
        Node node = this.getNode();
        if (node instanceof AutomaticTaskNode) {
            ActionHandler handler = this.getActionHandler();
            if (handler instanceof IExecutable) {
                ((IExecutable)handler).abort();
            }
        } else {
            this.fail();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recover(boolean resume) {
        if (this.status != ProcessStatus.CREATED && this.status != ProcessStatus.RUNNING && this.status != ProcessStatus.BUSY && this.status != ProcessStatus.BRANCHED && this.status != ProcessStatus.QUEUED) {
            return;
        }
        if (this.requestedStatus == ProcessStatus.PAUSED) {
            logger.info((Object)(this + ", pausing..."));
            this.resetRequestedStatus();
            this.suspend();
            return;
        }
        if (this.requestedStatus == ProcessStatus.CANCELLED) {
            logger.info((Object)(this + ", cancelling..."));
            this.resetRequestedStatus();
            this.cancel();
            return;
        }
        if (this.status == ProcessStatus.BRANCHED) {
            this.resetReactivateParentFlag();
            Collection<CustomToken> active = this.getActiveChildTokens();
            if (!active.isEmpty()) {
                for (CustomToken token : active) {
                    token.recover(resume);
                }
                return;
            } else {
                logger.warn((Object)(this + " no active children"));
                this.join(this.getLastChild());
            }
            return;
        } else {
            if (!this.trylock()) {
                logger.warn((Object)(this + ", already recovered?"));
                return;
            }
            try {
                if (this.node instanceof ProcessState && this.subProcessInstance != null) {
                    logger.info((Object)(this + " has a child process, recovery not required"));
                    return;
                }
                logger.info((Object)(this + ", performing crash recovery"));
                boolean queued = this.status == ProcessStatus.QUEUED;
                this.closeTaskInstance();
                this.setRequestedStatus(ProcessStatus.ERROR);
                this.setStatus(ProcessStatus.ERROR);
                this.fireEvent(WorkflowProcessEventType.CRASHED);
                if (!queued && !resume) return;
                if (this.node instanceof StartState || this.hasParent() && this.node instanceof Fork) {
                    this.setStatus(ProcessStatus.CREATED);
                    this.start();
                    return;
                }
                if (this.hasParent() && this.node instanceof Join) {
                    this.setStatus(ProcessStatus.RUNNING);
                    this.setRequestedStatus(ProcessStatus.RUNNING);
                    this.node.execute((org.jbpm.graph.exe.ExecutionContext)new ExecutionContext(this));
                    return;
                }
                super.resume();
                this.setResuming(true);
                this.setRequestedStatus(ProcessStatus.RUNNING);
                this.fireEvent(WorkflowProcessEventType.RESUMED);
                this.signal();
                return;
            }
            finally {
                this.releaselock();
            }
        }
    }

    public void undo() {
        this.invoke(new UndoOperation());
    }

    public void acquire() {
        this.setStatus(ProcessStatus.BUSY);
        this.fireEvent(WorkflowProcessEventType.ACQUIRED);
    }

    public void release() {
        this.setStatus(ProcessStatus.RUNNING);
        this.fireEvent(WorkflowProcessEventType.RELEASED);
    }

    public void cancel() {
        this.check();
        if (this.status == ProcessStatus.COMPLETED || this.status == ProcessStatus.CANCELLED || this.requestedStatus == ProcessStatus.CANCELLED) {
            return;
        }
        logger.debug((Object)(this + " attempting to cancel..."));
        this.setRequestedStatus(ProcessStatus.CANCELLED);
        this.fireEvent(WorkflowProcessEventType.CANCELLING);
        this.takelock();
        try {
            if (this.status == ProcessStatus.COMPLETED || this.status == ProcessStatus.CANCELLED) {
                return;
            }
            this.setRequestedStatus(ProcessStatus.CANCELLED);
            this.end();
        }
        finally {
            this.releaselock();
        }
    }

    public void end() {
        if (this.hasEnded()) {
            return;
        }
        if (this.requestedStatus == ProcessStatus.CANCELLED) {
            this.end(new ExecutionContext(this));
            this.setStatus(ProcessStatus.CANCELLED);
            this.setRequestedStatus(ProcessStatus.CANCELLED);
            this.end = new Date();
            if (this.isRoot()) {
                this.processInstance.end();
            }
            this.fireEvent(WorkflowProcessEventType.CANCELLED);
        } else {
            this.end(new ExecutionContext(this));
            this.setStatus(ProcessStatus.COMPLETED);
            this.setRequestedStatus(ProcessStatus.COMPLETED);
            this.end = new Date();
            if (this.isRoot()) {
                this.processInstance.end();
            }
            this.fireEvent(WorkflowProcessEventType.STOPPED);
        }
    }

    private void end(ExecutionContext context) {
        ActionHandler handler = (ActionHandler)JbpmConfiguration.Configs.getObject((String)"jbpm.token.end.command");
        try {
            handler.execute((org.jbpm.graph.exe.ExecutionContext)context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetRequestedStatus() {
        this.requestedStatus = ProcessStatus.RUNNING;
        for (CustomToken token : this.getActiveChildTokens()) {
            ProcessStatus status = token.status;
            if (status != ProcessStatus.RUNNING && status != ProcessStatus.BUSY && status != ProcessStatus.CREATED) continue;
            token.setRequestedStatus(ProcessStatus.RUNNING);
        }
    }

    private void check() {
        if (!this.getProcessInstance().isActive()) {
            throw new InvalidProcessStateException(this.toString());
        }
    }

    private void fireEvent(WorkflowProcessEventType type) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowProcessEvent(this.getProcessInstance(), (Token)this, type));
    }

    private void fireFailureEvent(Throwable t) {
        DefaultMediator.getInstance().send((WorkflowEvent)new WorkflowProcessEvent(this.getProcessInstance(), (Token)this, t));
    }

    private Transition getArrivingTransition() {
        Node checkpoint = this.node;
        SuperState parent = this.node.getSuperState();
        if (parent != null) {
            checkpoint = ((NodeGroup)parent).first();
        }
        Set transitions = checkpoint.getArrivingTransitions();
        if (parent == null) {
            return (Transition)transitions.iterator().next();
        }
        for (Transition transition : transitions) {
            if (transition.getFrom().getSuperState() != null && transition.getFrom().getSuperState() == parent) continue;
            return transition;
        }
        return null;
    }

    private void resetReactivateParentFlag() {
        for (CustomToken token : this.getChildTokens()) {
            if (!token.hasEnded() || !token.isAbleToReactivateParent()) continue;
            token.setAbleToReactivateParent(false);
            logger.info((Object)(this + " reset child's flag " + token));
        }
    }

    protected CustomToken getLastChild() {
        return Collections.max(this.getChildTokens(), new Comparator<CustomToken>(){

            @Override
            public int compare(CustomToken c1, CustomToken c2) {
                return c1.getEnd().compareTo(c2.getEnd());
            }
        });
    }

    private void closeTaskInstance() {
        TaskMgmtInstance tmi = this.processInstance.getTaskMgmtInstance();
        if (tmi == null) {
            return;
        }
        Collection instances = tmi.getTaskInstances();
        if (instances == null) {
            return;
        }
        for (TaskInstance ti : instances) {
            if (ti.hasEnded() || !this.equals(ti.getToken())) continue;
            ti.setSignalling(false);
            ti.end();
        }
    }

    private void takelock() {
        this.lock.lock();
        logger.debug((Object)(this + " locked"));
    }

    private boolean trylock() {
        return this.lock.tryLock();
    }

    private void releaselock() {
        this.lock.unlock();
        logger.debug((Object)(this + " unlocked"));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.contextStack = new ArrayDeque<ExecutionContext>();
    }

    private void invoke(TokenOperation op) {
        op.doOp();
    }

    public String toString() {
        return "[" + this.processInstance.getId() + ":" + this.getId() + "] " + (Object)((Object)this.status);
    }

    private abstract class TokenOperation {
        private TokenOperation() {
        }

        abstract void doOp();
    }

    private class UndoOperation
    extends TokenOperation {
        private UndoOperation() {
        }

        @Override
        void doOp() {
            if (CustomToken.this.getStatus() == ProcessStatus.CANCELLED || CustomToken.this.getRequestedStatus() == ProcessStatus.CANCELLED) {
                return;
            }
            CustomToken.this.setRequestedStatus(ProcessStatus.CANCELLED);
            CustomToken.this.fireEvent(WorkflowProcessEventType.CANCELLING);
            CustomToken.this.takelock();
            if (CustomToken.this.getStatus() == ProcessStatus.CANCELLED) {
                return;
            }
            try {
                try {
                    CustomToken.this.getProcessInstance().getContextInstance().setTransientVariable("_undo_", (Object)Boolean.TRUE);
                    if (CustomToken.this.getStatus() == ProcessStatus.BRANCHED) {
                        for (CustomToken child : CustomToken.this.getCurrentChildTokens()) {
                            child.undo();
                        }
                    }
                    ExecutionContext context = CustomToken.this.popContext();
                    while (context != null) {
                        Node node = context.getNode();
                        CustomToken.this.setNode(node);
                        ((IUndoableNode)IUndoableNode.class.cast(node)).undo(context);
                        context = CustomToken.this.popContext();
                    }
                }
                catch (Throwable t) {
                    logger.warn((Object)(this + ", failed to undo"), t);
                    CustomToken.this.end();
                    CustomToken.this.releaselock();
                }
            }
            finally {
                CustomToken.this.end();
                CustomToken.this.releaselock();
            }
        }
    }
}

