/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import bsh.EvalError;
import bsh.Interpreter;
import com.tandbergtv.workflow.core.DurationUtility;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

public class WFSInterpreter {
    private ExecutionContext executionContext = null;
    private Interpreter interpreter;
    private static final Logger logger = Logger.getLogger(WFSInterpreter.class);

    public WFSInterpreter(ExecutionContext execContext) {
        this.executionContext = execContext;
        this.interpreter = new Interpreter();
        this.addInputVars(this.interpreter);
    }

    public Object evaluate(String expression) {
        logger.debug((Object)("Evaluating Expression:" + expression));
        Object value = null;
        try {
            value = this.interpreter.eval(expression);
        }
        catch (EvalError e) {
            throw new RuntimeException("Could not evaluate expression " + expression, e);
        }
        return value;
    }

    private void addInputVars(Interpreter interpreter) {
        try {
            interpreter.set("util", (Object)new DurationUtility());
            interpreter.set("executionContext", (Object)this.executionContext);
        }
        catch (EvalError e) {
            throw new RuntimeException("Error adding variables to interpreter.");
        }
    }
}

